/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.block.storage.jar.SpiritJarBlock;
import com.sammy.malum.common.block.storage.jar.SpiritJarBlockEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.Vec3;

public class GazeGreaterArcaneRiteType
extends TotemicRiteType {
    public GazeGreaterArcaneRiteType() {
        super("gaze_greater_arcane_rite", new MalumSpiritType[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT});
    }

    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                if (totemBase.activeRite == null) {
                    return;
                }
                Vec3 center = Vec3.atCenterOf((Vec3i)this.getRiteEffectCenter(totemBase));
                List chests = this.getNearbyBlocks(totemBase, ChestBlock.class).toList();
                List spiritJarPositions = this.getNearbyBlocks(totemBase, SpiritJarBlock.class).toList();
                this.getNearbyEntities(totemBase, ItemEntity.class).forEach(itemEntity -> {
                    ItemStack stack = itemEntity.getItem();
                    boolean insertedIntoJar = false;
                    for (BlockPos jarPos : spiritJarPositions) {
                        BlockEntity be = level.getBlockEntity(jarPos);
                        if (!(be instanceof SpiritJarBlockEntity)) continue;
                        SpiritJarBlockEntity jar = (SpiritJarBlockEntity)be;
                        Item patt0$temp = stack.getItem();
                        if (!(patt0$temp instanceof SpiritShardItem)) continue;
                        SpiritShardItem spiritItem = (SpiritShardItem)patt0$temp;
                        if (!jar.getInventory(Direction.NORTH).isItemValid(1, stack)) continue;
                        ItemStack remaining = jar.getInventory(Direction.NORTH).insertItem(1, stack, false);
                        if (remaining.isEmpty()) {
                            itemEntity.discard();
                            return;
                        }
                        itemEntity.setItem(remaining);
                    }
                    if (!insertedIntoJar) {
                        for (BlockPos chestPos : chests) {
                            BlockEntity blockEntity = level.getBlockEntity(chestPos);
                            if (!(blockEntity instanceof ChestBlockEntity)) continue;
                            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                            ItemStack remaining = this.insertItemIntoChest(chest, stack.copy());
                            chest.setChanged();
                            if (remaining.isEmpty()) {
                                itemEntity.discard();
                                return;
                            }
                            itemEntity.setItem(remaining);
                        }
                    }
                });
            }

            private ItemStack insertItemIntoChest(ChestBlockEntity chest, ItemStack stack) {
                for (int i = 0; i < chest.getContainerSize(); ++i) {
                    ItemStack slotStack = chest.getItem(i);
                    if (slotStack.isEmpty()) {
                        chest.setItem(i, stack);
                        return ItemStack.EMPTY;
                    }
                    if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)stack) || slotStack.getCount() >= slotStack.getMaxStackSize()) continue;
                    int transferable = Math.min(stack.getCount(), slotStack.getMaxStackSize() - slotStack.getCount());
                    slotStack.grow(transferable);
                    stack.shrink(transferable);
                    if (!stack.isEmpty()) continue;
                    return ItemStack.EMPTY;
                }
                return stack;
            }
        };
    }

    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
            }
        };
    }
}

