/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.weapons;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.visual_effects.networked.attack.SunderingAnchorSlashParticleEffect;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.common.entity.SplinteredWorldProjectileEntity;
import com.strawberry.gaze.common.item.curiosities.weapons.AstralSplinteredWorld;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.item.LodestoneCombatItem;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;

public class SplinteredWorld
extends LodestoneCombatItem
implements IMalumEventResponder,
ISpiritAffiliatedItem {
    public static final MalumSpiritType[] SPIRITS = new MalumSpiritType[]{MalumSpiritTypes.EARTHEN_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT};

    public SplinteredWorld(Tier tier, float magicDamage, LodestoneItemProperties properties) {
        super(tier, 5.5f, -3.0f, properties.component(DataComponents.TOOL, (Object)SplinteredWorld.createToolProperties(tier, (TagKey<Block>)MalumTags.BlockTags.MINEABLE_WITH_KNIFE)).mergeAttributes(ItemAttributeModifiers.builder().add((Holder)LodestoneAttributes.MAGIC_DAMAGE, new AttributeModifier(LodestoneAttributes.MAGIC_DAMAGE.getId(), (double)magicDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect((String)"splintered_world_effect", (Object[])new Object[0])});
    }

    public static MalumSpiritType getWorldSpirit() {
        return SPIRITS[MalumMod.RANDOM.nextInt(SPIRITS.length)];
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.equals((Object)Enchantments.BREACH)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public MalumSpiritType getDefiningSpiritType() {
        return SplinteredWorld.getWorldSpirit();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        BlockHitResult blockHitResult;
        if (usedHand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(usedHand));
        }
        HitResult hitResult = EntityHelper.pick((LivingEntity)player);
        if (hitResult instanceof BlockHitResult && level.getBlockState((blockHitResult = (BlockHitResult)hitResult).getBlockPos()).is(MalumTags.BlockTags.SUNDERING_ANCHOR_KNIFE_BEHAVIOR)) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
        }
        ItemStack weaponItem = player.getWeaponItem();
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.pass((Object)weaponItem);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int slot = usedHand == InteractionHand.OFF_HAND ? player.getInventory().getContainerSize() - 1 : player.getInventory().selected;
            float physicalDamage = (float)player.getAttributes().getValue(Attributes.ATTACK_DAMAGE);
            float magicDamage = (float)player.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE);
            Vec3 pos = this.getProjectileSpawnPos((LivingEntity)player, usedHand, 0.5f, 0.5f);
            SplinteredWorldProjectileEntity entity = new SplinteredWorldProjectileEntity(level, pos.x, pos.y, pos.z);
            entity.setData((LivingEntity)player, physicalDamage, magicDamage, slot);
            entity.setItem(new ItemStack((ItemLike)((Item)GazeMod.ASTRAL_SPLINTERED_WORLDV1.get()).asItem()));
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 0.0f);
            level.addFreshEntity((Entity)entity);
            SoundHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)MalumSoundEvents.SUNDERING_ANCHOR_THROW.get()), (float)0.5f, (float)RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)1.5f, (float)2.0f));
            AstralSplinteredWorld.disable(serverPlayer, slot, GazeMod.ASTRAL_SPLINTERED_WORLD);
        }
        return InteractionResultHolder.success((Object)weaponItem);
    }

    public Vec3 getProjectileSpawnPos(LivingEntity player, InteractionHand hand, float distance, float spread) {
        int angle = hand == InteractionHand.MAIN_HAND ? 225 : 90;
        double radians = Math.toRadians((float)angle - player.yHeadRot);
        return player.position().add(player.getLookAngle().scale((double)distance)).add((double)spread * Math.sin(radians), (double)(player.getBbHeight() * 0.9f), (double)spread * Math.cos(radians));
    }

    public static Tool createToolProperties(Tier tier, TagKey<Block> blocks) {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f), Tool.Rule.deniesDrops((TagKey)tier.getIncorrectBlocksForDrops()), Tool.Rule.minesAndDrops(blocks, (float)tier.getSpeed())), 1.0f, 2);
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            DamageSource source = event.getSource();
            RandomSource random = level2.random;
            if (source.is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC)) {
                target.hurtMarked = true;
                float damage = event.getNewDamage();
                event.setNewDamage(damage);
                float pitch = RandomHelper.randomBetween((RandomSource)level2.getRandom(), (float)0.75f, (float)2.0f);
                SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)MalumSoundEvents.SUNDERING_ANCHOR_SWING.get()), (float)2.0f, (float)pitch);
                MalumParticleEffectTypes.SUNDERING_ANCHOR_SLASH.createEffect().originatesFrom((Entity)attacker).forwardOffset(1.5f).horizontalOffset(0.3f).upwardOffset(-0.2f).color(SPIRITS).customData((WeaponParticleEffectType.WeaponParticleEffectData)new SunderingAnchorSlashParticleEffect.SunderingAnchorSlashEffectData(1)).randomSlashRotation(random).spawn(level2);
            }
        }
    }

    public static void applyCooldown(ItemStack stack, Player player) {
        if (!player.isCreative()) {
            int cooldown = 50;
            player.getCooldowns().addCooldown(stack.getItem(), cooldown);
        }
    }
}

