/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.curios.runes;

import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.curios.runes.AbstractRuneCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.core.systems.spirit.SpiritVisualMotif;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.item.MalumItems;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.easing.Easing;

public class RuneVoidItem
extends AbstractRuneCurioItem
implements IMalumEventResponder {
    public RuneVoidItem(Item.Properties builder) {
        super(builder, MalumSpiritTypes.UMBRAL_SPIRIT);
    }

    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect((String)"rune_of_void", (Object[])new Object[0]));
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!event.getSource().is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC)) {
            return;
        }
        float baseArmor = target.getArmorValue();
        int magicDamage = (int)Math.floor(baseArmor / 10.0f);
        if ((magicDamage = Math.max(0, magicDamage)) == 0) {
            return;
        }
        if (target.isAlive()) {
            target.invulnerableTime = 0;
            target.hurt(DamageTypeHelper.create((Level)level2, (ResourceKey)MalumDamageTypes.VOID, (Entity)attacker), (float)magicDamage);
        }
        MalumSpiritType test = MalumSpiritType.create((String)"wicked", (SpiritVisualMotif)new SpiritVisualMotif(new Color(255, 255, 255), new Color(255, 255, 255), 0.8f, Easing.LINEAR), (Supplier)MalumItems.UMBRAL_SPIRIT).build();
        SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)MalumSoundEvents.TYRVING_SLASH.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)attacker.getRandom(), (float)1.0f, (float)1.5f));
        MalumParticleEffectTypes.TYRVING_SLASH.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).verticalSlashRotation().color(stack.getItem()).horizontalOffset(0.2f).forwardOffset(0.8f).upwardOffset(-0.2f).spawn(level2);
    }
}

