/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.event;

import com.sammy.malum.registry.common.item.MalumItems;
import com.strawberry.gaze.Config;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.common.item.curiosities.weapons.VeilDaggerItem;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public class GazeEvents {
    private static final Set<String> playerVictimPairs = new HashSet<String>();

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        boolean isUsingVeilDagger;
        DamageSource source = event.getSource();
        Entity entity = source.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        LivingEntity victim = event.getEntity();
        if (!(victim instanceof Player) && !this.isConfiguredUmbralDropEntity(victim)) {
            return;
        }
        if (this.isConfiguredUmbralDropEntity(victim) && !(victim instanceof Player)) {
            if (!Config.mobsDropUmbralsOnServer && !player.getServer().isSingleplayer()) {
                return;
            }
            if ((double)player.getRandom().nextFloat() > Config.umbralDropChance) {
                return;
            }
        }
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        boolean bl = isUsingVeilDagger = main.getItem() instanceof VeilDaggerItem || off.getItem() instanceof VeilDaggerItem || main.getItem() == GazeMod.SOUL_OF_THE_VEIL_DAGGER.get() || off.getItem() == GazeMod.SOUL_OF_THE_VEIL_DAGGER.get();
        if (!isUsingVeilDagger) {
            return;
        }
        if (victim instanceof Player) {
            UUID playerUUID = player.getUUID();
            UUID victimUUID = victim.getUUID();
            String pairKey = String.valueOf(playerUUID) + ":" + String.valueOf(victimUUID);
            if (playerVictimPairs.contains(pairKey)) {
                return;
            }
            playerVictimPairs.add(pairKey);
        }
        ItemStack drop = new ItemStack((ItemLike)MalumItems.UMBRAL_SPIRIT.get());
        ItemEntity itemEntity = new ItemEntity(victim.level(), victim.getX(), victim.getY(), victim.getZ(), drop);
        event.getDrops().add(itemEntity);
    }

    @SubscribeEvent
    public void onLivingConvertPre(LivingConversionEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        EntityType outcome = event.getOutcome();
        if ((entity instanceof Piglin || entity instanceof Hoglin) && outcome == EntityType.ZOMBIFIED_PIGLIN && entity.getTags().contains("gaze.prevent_zombify") && entity.level().dimension() == Level.OVERWORLD) {
            event.setCanceled(true);
        }
    }

    private boolean isConfiguredUmbralDropEntity(LivingEntity entity) {
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        return id != null && Config.umbralDropEntities.contains(id.toString());
    }
}

