/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block.entity;

import cy.jdkdigital.productivelib.common.block.entity.FluidTankBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.IMultiBlockPeripheralBlockEntity;
import cy.jdkdigital.productivelib.util.ImmutableFluidStack;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryControllerBlockEntity;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FoundryTankBlockEntity
extends FluidTankBlockEntity
implements IMultiBlockPeripheralBlockEntity {
    private BlockPos controllerPosition;
    public FluidTank fluidHandler = new FluidTank(4000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            Level level = FoundryTankBlockEntity.this.level;
            if (level instanceof ServerLevel) {
                BlockEntity blockEntity;
                ServerLevel serverLevel = (ServerLevel)level;
                if (FoundryTankBlockEntity.this.getMultiblockController() != null && (blockEntity = serverLevel.getBlockEntity(FoundryTankBlockEntity.this.getMultiblockController())) instanceof FoundryControllerBlockEntity) {
                    FoundryControllerBlockEntity foundry = (FoundryControllerBlockEntity)blockEntity;
                    foundry.sync((Level)serverLevel);
                }
                FoundryTankBlockEntity.this.sync((Level)serverLevel);
            }
        }
    };

    public FoundryTankBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)MetalworksRegistrator.FOUNDRY_TANK_BLOCK_ENTITY.get(), pos, blockState);
    }

    public void tickFluidTank(Level level, BlockPos blockPos, BlockState blockState, FluidTankBlockEntity fluidTankBlockEntity) {
        FoundryTankBlockEntity belowTank;
        BlockEntity blockEntity = level.getBlockEntity(blockPos.below());
        if (blockEntity instanceof FoundryTankBlockEntity && (belowTank = (FoundryTankBlockEntity)blockEntity).getFluidHandler().getSpace() > 0) {
            FluidUtil.tryFluidTransfer((IFluidHandler)belowTank.getFluidHandler(), (IFluidHandler)fluidTankBlockEntity.getFluidHandler(), (int)1000, (boolean)true);
        }
    }

    public FluidTank getFluidHandler() {
        return this.fluidHandler;
    }

    public void setMultiblockController(BlockPos pos) {
        this.controllerPosition = pos;
    }

    public BlockPos getMultiblockController() {
        return this.controllerPosition;
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.controllerPosition != null) {
            tag.putLong("controller", this.controllerPosition.asLong());
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("controller")) {
            this.controllerPosition = BlockPos.of((long)tag.getLong("controller"));
        }
    }

    public void sync(Level level) {
        level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, FoundryTankBlockEntity tankBlockEntity) {
        FluidTankBlockEntity.tick((Level)level, (BlockPos)blockPos, (BlockState)blockState, (FluidTankBlockEntity)tankBlockEntity);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        ImmutableFluidStack fluid = (ImmutableFluidStack)componentInput.getOrDefault(MetalworksRegistrator.FLUID_STACK.get(), (Object)ImmutableFluidStack.EMPTY);
        if (!fluid.fluid().isEmpty()) {
            this.getFluidHandler().setFluid(fluid.fluid().copy());
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (!this.getFluidHandler().getFluid().isEmpty()) {
            components.set(MetalworksRegistrator.FLUID_STACK.get(), (Object)new ImmutableFluidStack(this.getFluidHandler().getFluid().copy()));
        }
    }
}

