/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.nature;

import com.gametechbc.spelllib.particle.CylinderParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.spells.TargetedTargetAreaCastData;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class PetalBurstSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"petal_ward");
    private static final int MAX_TARGETS = 10;
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.NATURE_RESOURCE).setMaxLevel(5).setCooldownSeconds(90.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}));
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        float radius = this.getRange(spellLevel);
        CylinderParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)(10 * spellLevel), (ParticleOptions)ParticleTypes.CHERRY_LEAVES, (ParticleDirection)ParticleDirection.UPWARD, (double)radius, (double)(4 * spellLevel), (double)-1.0);
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(8, entity.position(), radius / 2.0f));
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public PetalBurstSpell() {
        this.manaCostPerLevel = 25;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 3;
        this.castTime = 50;
        this.baseManaCost = 50;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        if (Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)32, (float)0.35f)) {
            float radius = 3.0f;
            LivingEntity target = ((TargetEntityCastData)playerMagicData.getAdditionalCastData()).getTarget((ServerLevel)level);
            TargetedAreaEntity area = TargetedAreaEntity.createTargetAreaEntity((Level)level, (Vec3)target.position(), (float)radius, (int)((MobEffect)MobEffectRegistry.BLIGHT.get()).getColor(), (Entity)target);
            playerMagicData.setAdditionalCastData((ICastData)new TargetedTargetAreaCastData(target, area));
            return true;
        }
        return false;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetedTargetAreaCastData targetData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetedTargetAreaCastData && (targetEntity = (targetData = (TargetedTargetAreaCastData)iCastData).getTarget((ServerLevel)world)) != null) {
            float radius = 3.0f;
            float damage = this.getDamage(spellLevel, entity);
            AtomicInteger targets = new AtomicInteger(0);
            targetEntity.level().getEntitiesOfClass(LivingEntity.class, targetEntity.getBoundingBox().inflate((double)radius)).forEach(victim -> {
                if (targets.get() < 10 && victim != entity && victim.distanceToSqr((Entity)targetEntity) < (double)(radius * radius) && !DamageSources.isFriendlyFireBetween((Entity)entity, (Entity)victim)) {
                    DamageSources.applyDamage((Entity)victim, (float)damage, (DamageSource)this.getDamageSource((Entity)targetEntity, (Entity)entity));
                    targets.incrementAndGet();
                    CylinderParticleManager.spawnParticles((Level)world, (LivingEntity)victim, (int)(50 * spellLevel), (ParticleOptions)ParticleTypes.CHERRY_LEAVES, (ParticleDirection)ParticleDirection.UPWARD, (double)radius, (double)(4 * spellLevel), (double)-1.0);
                    CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(8, entity.position(), radius / 2.0f));
                    victim.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 150, 1));
                }
            });
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float getRange(int spellLevel) {
        return 4.0f;
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_RAISED_HAND;
    }
}

