/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.ice;

import com.gametechbc.spelllib.particle.CylinderParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.registries.ParticleRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

@AutoSpellConfig
public class SnowgraveSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"snow_grave");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(5).setCooldownSeconds(130.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.translatable((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel, caster), (int)2)}), Component.translatable((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(spellLevel, caster), (int)2)}));
    }

    public SnowgraveSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 3;
        this.castTime = 24;
        this.baseManaCost = 250;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float radius = this.getRadius(spellLevel, entity);
        float range = 4.0f;
        entity.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 20, 3, false, false, false));
        entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 15, 0, false, false, false));
        Vec3 smiteLocation = Utils.raycastForBlock((Level)level, (Vec3)entity.getEyePosition(), (Vec3)entity.getEyePosition().add(entity.getForward().multiply((double)range, 0.0, (double)range)), (ClipContext.Fluid)ClipContext.Fluid.NONE).getLocation();
        Vec3 particleLocation = level.clip(new ClipContext(smiteLocation, smiteLocation.add(0.0, -2.0, 0.0), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty())).getLocation().add(0.0, 0.1, 0.0);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ICE.get()).getTargetingColor(), radius * 2.0f), (double)particleLocation.x, (double)particleLocation.y, (double)particleLocation.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ICE.get()).getTargetingColor(), radius * 2.0f), (double)particleLocation.x, (double)particleLocation.y, (double)particleLocation.z, (int)1, (double)0.0, (double)2.0, (double)0.0, (double)0.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ICE.get()).getTargetingColor(), radius * 2.0f), (double)particleLocation.x, (double)particleLocation.y, (double)particleLocation.z, (int)1, (double)0.0, (double)-2.0, (double)0.0, (double)0.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ICE.get()).getTargetingColor(), radius * 2.0f), (double)particleLocation.x, (double)particleLocation.y, (double)particleLocation.z, (int)3, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.SNOWFLAKE, (double)entity.getX(), (double)(entity.getY() + 1.0), (double)entity.getZ(), (int)50, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)false);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)((ParticleOptions)ParticleRegistry.SNOW_DUST.get()), (double)entity.getX(), (double)(entity.getY() + 1.0), (double)entity.getZ(), (int)50, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)false);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.SNOWFLAKE, (double)particleLocation.x, (double)particleLocation.y, (double)particleLocation.z, (int)50, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)false);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)particleLocation.x, (double)particleLocation.y, (double)particleLocation.z, (int)50, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)false);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.ICY_FOG, (double)entity.getX(), (double)(entity.getY() + 1.0), (double)entity.getZ(), (int)80, (double)0.45, (double)0.45, (double)0.45, (double)(0.6f + radius * 0.4f), (boolean)false);
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(10, particleLocation, 10.0f));
        CylinderParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)70, (ParticleOptions)ParticleTypes.SNOWFLAKE, (ParticleDirection)ParticleDirection.OUTWARD, (double)6.0, (double)10.0, (double)3.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
        List entities = level.getEntities((Entity)entity, AABB.ofSize((Vec3)smiteLocation, (double)(radius * 2.0f), (double)(radius * 4.0f), (double)(radius * 2.0f)));
        SpellDamageSource damageSource = this.getDamageSource((Entity)entity);
        for (Entity targetEntity : entities) {
            if (!targetEntity.isAlive() || !targetEntity.isPickable() || !Utils.hasLineOfSight((Level)level, (Vec3)smiteLocation.add(0.0, 1.0, 0.0), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)true) || DamageSources.applyDamage((Entity)targetEntity, (float)this.getDamage(spellLevel, entity), (DamageSource)damageSource)) {
                // empty if block
            }
            targetEntity.setTicksFrozen(90);
            level.getEntities((Entity)entity, entity.getBoundingBox().inflate((double)radius, 4.0, (double)radius), target -> !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)entity) && Utils.hasLineOfSight((Level)level, (Entity)entity, (Entity)target, (boolean)true)).forEach(target -> {
                LivingEntity livingEntity;
                if (target instanceof LivingEntity && (livingEntity = (LivingEntity)target).distanceToSqr((Entity)entity) < (double)(radius * radius)) {
                    int i = this.getDuration(spellLevel, entity);
                    livingEntity.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.CHILLED, i, this.getChillAmplifier(spellLevel, entity)));
                    MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)livingEntity.getX(), (double)(livingEntity.getY() + (double)(livingEntity.getBbHeight() * 0.5f)), (double)livingEntity.getZ(), (int)50, (double)(livingEntity.getBbWidth() * 0.5f), (double)(livingEntity.getBbHeight() * 0.5f), (double)(livingEntity.getBbWidth() * 0.5f), (double)0.03, (boolean)false);
                }
                super.onCast(level, spellLevel, entity, castSource, playerMagicData);
            });
        }
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.PREPARE_CROSS_ARMS;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.CHARGE_WAVY_ANIMATION;
    }

    public float getRadius(int spellLevel, LivingEntity caster) {
        return 5.0f + (float)spellLevel * 0.5f;
    }

    public int getDuration(int spellLevel, LivingEntity caster) {
        return (int)(this.getSpellPower(spellLevel, (Entity)caster) * 20.0f);
    }

    public int getChillAmplifier(int spellLevel, LivingEntity caster) {
        return 1;
    }
}

