/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.fire;

import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.ender.endersequipment.entity.spells.pale_flame.PaleFlame;
import net.ender.endersequipment.entity.spells.pale_flame.PaleFlame40;
import net.ender.endersequipment.entity.spells.pale_flame.PaleFlame60;
import net.ender.endersequipment.entity.spells.pale_flame.PaleFlame80;
import net.ender.endersequipment.registries.EESchoolRegistry;
import net.ender.endersequipment.registries.SoundRegistry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class PaleFlameSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"pale_flame");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(EESchoolRegistry.ELDRITCH_RESOURCE).setMaxLevel(1).setCooldownSeconds(200.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{this.getDamageText(spellLevel, caster)}));
    }

    public PaleFlameSpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 6;
        this.spellPowerPerLevel = 2;
        this.castTime = 10;
        this.baseManaCost = 450;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.PALE_FLAME_END.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.PALE_FLAME_START.get());
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        PaleFlame over;
        boolean mirrored;
        Vec3 offsetVector;
        SpellDamageSource damageSource;
        List entities;
        Vec3 hitLocation;
        Vec3 forward;
        float distance;
        float radius;
        float MAX_HEALTH = entity.getMaxHealth();
        float baseHealth = entity.getHealth();
        double percent = baseHealth / MAX_HEALTH * 100.0f;
        if (percent <= 100.0) {
            radius = 3.25f;
            distance = 1.9f;
            forward = entity.getForward();
            hitLocation = entity.position().add(0.0, (double)(entity.getBbHeight() * 0.3f), 0.0).add(forward.scale((double)distance));
            entities = level.getEntities((Entity)entity, AABB.ofSize((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
            damageSource = this.getDamageSource((Entity)entity);
            for (Entity targetEntity : entities) {
                if (!(targetEntity instanceof LivingEntity) || !targetEntity.isAlive() || !entity.isPickable() || !(targetEntity.position().subtract(entity.getEyePosition()).dot(forward) >= 0.0) || !(entity.distanceToSqr(targetEntity) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.getEyePosition(), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)true) || !((offsetVector = targetEntity.getBoundingBox().getCenter().subtract(entity.getEyePosition())).dot(forward) >= 0.0) || !DamageSources.applyDamage((Entity)targetEntity, (float)this.getDamage(spellLevel, entity), (DamageSource)damageSource)) continue;
                ((LivingEntity)targetEntity).addEffect(new MobEffectInstance(MobEffects.GLOWING, 120, 1));
                ((LivingEntity)targetEntity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 120, 1));
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)level), (Entity)targetEntity, (DamageSource)damageSource);
            }
            mirrored = playerMagicData.getCastingEquipmentSlot().equals(SpellSelectionManager.OFFHAND);
            over = new PaleFlame(level, mirrored);
            over.moveTo(hitLocation);
            over.setYRot(entity.getYRot());
            over.setXRot(entity.getXRot());
            level.addFreshEntity((Entity)over);
            level.getEntities((Entity)entity, entity.getBoundingBox().inflate((double)radius, 4.0, (double)radius), target -> !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)entity) && Utils.hasLineOfSight((Level)level, (Entity)entity, (Entity)target, (boolean)true)).forEach(target -> super.onCast(level, spellLevel, entity, castSource, playerMagicData));
        }
        if (percent <= 80.0) {
            radius = 3.25f;
            distance = 1.9f;
            forward = entity.getForward();
            hitLocation = entity.position().add(0.0, (double)(entity.getBbHeight() * 0.3f), 0.0).add(forward.scale((double)distance));
            entities = level.getEntities((Entity)entity, AABB.ofSize((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
            damageSource = this.getDamageSource((Entity)entity);
            for (Entity targetEntity : entities) {
                if (!(targetEntity instanceof LivingEntity) || !targetEntity.isAlive() || !entity.isPickable() || !(targetEntity.position().subtract(entity.getEyePosition()).dot(forward) >= 0.0) || !(entity.distanceToSqr(targetEntity) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.getEyePosition(), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)true) || !((offsetVector = targetEntity.getBoundingBox().getCenter().subtract(entity.getEyePosition())).dot(forward) >= 0.0) || !DamageSources.applyDamage((Entity)targetEntity, (float)(this.getDamage(spellLevel, entity) * 1.2f), (DamageSource)damageSource)) continue;
                ((LivingEntity)targetEntity).addEffect(new MobEffectInstance(MobEffects.GLOWING, 120, 1));
                ((LivingEntity)targetEntity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 120, 1));
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)level), (Entity)targetEntity, (DamageSource)damageSource);
            }
            mirrored = playerMagicData.getCastingEquipmentSlot().equals(SpellSelectionManager.OFFHAND);
            over = new PaleFlame80(level, mirrored);
            over.moveTo(hitLocation);
            over.setYRot(entity.getYRot());
            over.setXRot(entity.getXRot());
            level.addFreshEntity((Entity)over);
            level.getEntities((Entity)entity, entity.getBoundingBox().inflate((double)radius, 4.0, (double)radius), target -> !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)entity) && Utils.hasLineOfSight((Level)level, (Entity)entity, (Entity)target, (boolean)true)).forEach(target -> super.onCast(level, spellLevel, entity, castSource, playerMagicData));
        }
        if (percent <= 60.0) {
            radius = 3.25f;
            distance = 1.9f;
            forward = entity.getForward();
            hitLocation = entity.position().add(0.0, (double)(entity.getBbHeight() * 0.3f), 0.0).add(forward.scale((double)distance));
            entities = level.getEntities((Entity)entity, AABB.ofSize((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
            damageSource = this.getDamageSource((Entity)entity);
            for (Entity targetEntity : entities) {
                if (!(targetEntity instanceof LivingEntity) || !targetEntity.isAlive() || !entity.isPickable() || !(targetEntity.position().subtract(entity.getEyePosition()).dot(forward) >= 0.0) || !(entity.distanceToSqr(targetEntity) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.getEyePosition(), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)true) || !((offsetVector = targetEntity.getBoundingBox().getCenter().subtract(entity.getEyePosition())).dot(forward) >= 0.0) || !DamageSources.applyDamage((Entity)targetEntity, (float)(this.getDamage(spellLevel, entity) * 2.0f), (DamageSource)damageSource)) continue;
                ((LivingEntity)targetEntity).addEffect(new MobEffectInstance(MobEffects.GLOWING, 120, 1));
                ((LivingEntity)targetEntity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 120, 1));
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)level), (Entity)targetEntity, (DamageSource)damageSource);
            }
            mirrored = playerMagicData.getCastingEquipmentSlot().equals(SpellSelectionManager.OFFHAND);
            over = new PaleFlame60(level, mirrored);
            over.moveTo(hitLocation);
            over.setYRot(entity.getYRot());
            over.setXRot(entity.getXRot());
            level.addFreshEntity((Entity)over);
            level.getEntities((Entity)entity, entity.getBoundingBox().inflate((double)radius, 4.0, (double)radius), target -> !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)entity) && Utils.hasLineOfSight((Level)level, (Entity)entity, (Entity)target, (boolean)true)).forEach(target -> super.onCast(level, spellLevel, entity, castSource, playerMagicData));
        }
        if (percent <= 30.0) {
            radius = 3.25f;
            distance = 1.9f;
            forward = entity.getForward();
            hitLocation = entity.position().add(0.0, (double)(entity.getBbHeight() * 0.3f), 0.0).add(forward.scale((double)distance));
            entities = level.getEntities((Entity)entity, AABB.ofSize((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
            damageSource = this.getDamageSource((Entity)entity);
            for (Entity targetEntity : entities) {
                if (!(targetEntity instanceof LivingEntity) || !targetEntity.isAlive() || !entity.isPickable() || !(targetEntity.position().subtract(entity.getEyePosition()).dot(forward) >= 0.0) || !(entity.distanceToSqr(targetEntity) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.getEyePosition(), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)true) || !((offsetVector = targetEntity.getBoundingBox().getCenter().subtract(entity.getEyePosition())).dot(forward) >= 0.0) || !DamageSources.applyDamage((Entity)targetEntity, (float)(this.getDamage(spellLevel, entity) * 3.0f), (DamageSource)damageSource)) continue;
                ((LivingEntity)targetEntity).addEffect(new MobEffectInstance(MobEffects.GLOWING, 120, 1));
                ((LivingEntity)targetEntity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 120, 1));
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)level), (Entity)targetEntity, (DamageSource)damageSource);
            }
            boolean mirrored2 = playerMagicData.getCastingEquipmentSlot().equals(SpellSelectionManager.OFFHAND);
            over = new PaleFlame40(level, mirrored2);
            over.moveTo(hitLocation);
            over.setYRot(entity.getYRot());
            over.setXRot(entity.getXRot());
            level.addFreshEntity((Entity)over);
            level.getEntities((Entity)entity, entity.getBoundingBox().inflate((double)radius, 4.0, (double)radius), target -> !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)entity) && Utils.hasLineOfSight((Level)level, (Entity)entity, (Entity)target, (boolean)true)).forEach(target -> super.onCast(level, spellLevel, entity, castSource, playerMagicData));
            entity.addEffect(new MobEffectInstance(ALObjects.MobEffects.BLINDNESS, 100, 2, false, false, true));
            super.onCast(level, spellLevel, entity, castSource, playerMagicData);
        }
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) + this.getWeaponDamage(entity);
    }

    private float getWeaponDamage(LivingEntity entity) {
        if (entity == null) {
            return 0.0f;
        }
        float weaponDamage = Utils.getWeaponDamage((LivingEntity)entity);
        ItemStack weaponItem = entity.getWeaponItem();
        if (!weaponItem.isEmpty() && weaponItem.has(DataComponents.ENCHANTMENTS)) {
            weaponDamage += Utils.processEnchantment((Level)entity.level(), (ResourceKey)Enchantments.FIRE_ASPECT, (DataComponentType)EnchantmentEffectComponents.DAMAGE, (ItemEnchantments)((ItemEnchantments)weaponItem.get(DataComponents.ENCHANTMENTS)));
        }
        return weaponDamage;
    }

    private String getDamageText(int spellLevel, LivingEntity entity) {
        if (entity != null) {
            float weaponDamage = Utils.getWeaponDamage((LivingEntity)entity);
            String plus = "";
            if (weaponDamage > 0.0f) {
                plus = String.format(" (+%s)", Utils.stringTruncation((double)weaponDamage, (int)1));
            }
            String damage = Utils.stringTruncation((double)this.getDamage(spellLevel, entity), (int)1);
            return damage + plus;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)entity);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ONE_HANDED_HORIZONTAL_SWING_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }
}

