/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.fire;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.spells.fireball.MagicFireball;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.TargetAreaCastData;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class EruptionSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"eruption");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(5).setCooldownSeconds(120.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.translatable((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(caster), (int)1)}));
    }

    public EruptionSpell() {
        this.manaCostPerLevel = 4;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 2;
        this.castTime = 100;
        this.baseManaCost = 5;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.FIRE_CAST.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!(playerMagicData.getAdditionalCastData() instanceof TargetAreaCastData)) {
            Vec3 targetArea = Utils.moveToRelativeGroundLevel((Level)world, (Vec3)Utils.raycastForEntity((Level)world, (Entity)entity, (float)2.0f, (boolean)true).getLocation(), (int)12);
            playerMagicData.setAdditionalCastData((ICastData)new TargetAreaCastData(targetArea, TargetedAreaEntity.createTargetAreaEntity((Level)world, (Vec3)targetArea, (float)this.getRadius(entity), (int)0)));
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        ICastData iCastData;
        if (playerMagicData != null && (playerMagicData.getCastDurationRemaining() + 1) % 4 == 0 && (iCastData = playerMagicData.getAdditionalCastData()) instanceof TargetAreaCastData) {
            TargetAreaCastData targetAreaCastData = (TargetAreaCastData)iCastData;
            for (int i = 0; i < 2; ++i) {
                Vec3 center = targetAreaCastData.getCenter();
                float radius = this.getRadius(entity);
                Vec3 spawn = center.add(new Vec3(5.0, 0.0, (double)(entity.getRandom().nextFloat() * radius)).yRot((float)entity.getRandom().nextInt(360)));
                spawn = this.raiseWithCollision(spawn, 12, level);
                this.shootComet(level, spellLevel, entity, spawn);
                MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.FIRE_EMITTER, (double)spawn.x, (double)spawn.y, (double)spawn.z, (int)1, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (boolean)false);
                MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.FIERY_SPARKS, (double)spawn.x, (double)spawn.y, (double)spawn.z, (int)1, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (boolean)true);
            }
        }
    }

    private Vec3 raiseWithCollision(Vec3 start, int blocks, Level level) {
        Vec3 raised;
        for (int i = 0; i < blocks && level.getBlockState(BlockPos.containing((Position)(raised = start.add(0.0, 1.0, 0.0)))).isAir(); ++i) {
            start = raised;
        }
        return start;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 0.5f;
    }

    private float getRadius(LivingEntity caster) {
        return 6.0f;
    }

    public void shootComet(Level world, int spellLevel, LivingEntity entity, Vec3 spawn) {
        MagicFireball fireball = new MagicFireball(world, entity);
        fireball.setPos(spawn.add(-1.0, 0.0, 0.0));
        fireball.shoot(new Vec3((double)0.1f, (double)-0.85f, 0.0));
        fireball.setDamage(this.getDamage(spellLevel, entity));
        fireball.setExplosionRadius(1.0f);
        world.addFreshEntity((Entity)fireball);
        world.playSound(null, spawn.x, spawn.y, spawn.z, SoundEvents.FIREWORK_ROCKET_BLAST, SoundSource.PLAYERS, 3.0f, 0.7f + Utils.random.nextFloat() * 2.0f);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ANIMATION_CONTINUOUS_OVERHEAD;
    }
}

