/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.evocation;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.events.SpellSummonEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.List;
import java.util.Optional;
import net.ender.endersequipment.entity.summoned_ravager.SummonedRavager;
import net.ender.endersequipment.registries.ModEffectRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

@AutoSpellConfig
public class SummonRavagerSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"summon_ravager");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(10).setCooldownSeconds(100.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.hp", (Object[])new Object[]{Float.valueOf(this.getRavagerHealth(spellLevel, null))}), Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Float.valueOf(this.getRavagerDamage(spellLevel, null))}));
    }

    public SummonRavagerSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 4;
        this.spellPowerPerLevel = 1;
        this.castTime = 20;
        this.baseManaCost = 50;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.EVOKER_PREPARE_SUMMON);
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTime = 100;
        SummonedRavager ravager = new SummonedRavager(world, entity);
        ravager.setPos(entity.position());
        ravager.getAttributes().getInstance(Attributes.ATTACK_DAMAGE).setBaseValue((double)this.getRavagerDamage(spellLevel, entity));
        ravager.getAttributes().getInstance(Attributes.MAX_HEALTH).setBaseValue((double)this.getRavagerHealth(spellLevel, entity));
        ravager.setHealth(ravager.getMaxHealth());
        SpellSummonEvent event = (SpellSummonEvent)NeoForge.EVENT_BUS.post((Event)new SpellSummonEvent(entity, (LivingEntity)ravager, this.spellId, spellLevel));
        world.addFreshEntity((Entity)event.getCreature());
        ravager.addEffect(new MobEffectInstance(ModEffectRegistry.SUMMONED_RAVAGER, summonTime, 0, false, false, false));
        int effectAmplifier = 0;
        if (entity.hasEffect(ModEffectRegistry.SUMMONED_RAVAGER)) {
            effectAmplifier += entity.getEffect(ModEffectRegistry.SUMMONED_RAVAGER).getAmplifier() + 1;
        }
        entity.addEffect(new MobEffectInstance(ModEffectRegistry.SUMMONED_RAVAGER, summonTime, effectAmplifier, false, false, true));
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float getRavagerHealth(int spellLevel, LivingEntity caster) {
        return 50 + spellLevel * 4;
    }

    private float getRavagerDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster);
    }
}

