/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.ender;

import com.gametechbc.spelllib.particle.CylinderParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import com.gametechbc.spelllib.particle.SphereParticleManager;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.particle.ShockwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.ParticleRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.ender.endersequipment.registries.ModEffectRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.joml.Vector3f;

@AutoSpellConfig
public class SupernovaSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"supernova");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(1).setCooldownSeconds(600.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}));
    }

    public SupernovaSpell() {
        this.manaCostPerLevel = 100;
        this.baseSpellPower = 150;
        this.spellPowerPerLevel = 0;
        this.castTime = 200;
        this.baseManaCost = 500;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.DEAD_KING_EXPLODE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.DEAD_KING_DEATH.get());
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        float radius = this.getRange(spellLevel);
        CylinderParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)(30 * spellLevel), (ParticleOptions)ParticleTypes.DRAGON_BREATH, (ParticleDirection)ParticleDirection.INWARD, (double)radius, (double)(4 * spellLevel), (double)-1.0);
        SphereParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)40, (ParticleOptions)((ParticleOptions)ParticleRegistry.UNSTABLE_ENDER_PARTICLE.get()), (ParticleDirection)ParticleDirection.INWARD, (double)8.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float radius = 16.0f;
        float range = 16.0f;
        Vector3f edge = new Vector3f(0.7f, 1.0f, 1.0f);
        Vector3f center = new Vector3f(1.0f, 1.0f, 1.0f);
        Vec3 smiteLocation = Utils.raycastForBlock((Level)level, (Vec3)entity.getEyePosition(), (Vec3)entity.getEyePosition().add(entity.getForward().multiply((double)range, 0.0, (double)range)), (ClipContext.Fluid)ClipContext.Fluid.NONE).getLocation();
        Vec3 particleLocation = level.clip(new ClipContext(smiteLocation, smiteLocation.add(0.0, -2.0, 0.0), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty())).getLocation().add(0.0, 0.1, 0.0);
        SphereParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)80, (ParticleOptions)ParticleHelper.UNSTABLE_ENDER, (ParticleDirection)ParticleDirection.OUTWARD, (double)8.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
        SphereParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)80, (ParticleOptions)ParticleHelper.UNSTABLE_ENDER, (ParticleDirection)ParticleDirection.INWARD, (double)16.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
        SphereParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)150, (ParticleOptions)ParticleTypes.END_ROD, (ParticleDirection)ParticleDirection.UPWARD, (double)10.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
        SphereParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)150, (ParticleOptions)ParticleTypes.DRAGON_BREATH, (ParticleDirection)ParticleDirection.UPWARD, (double)10.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ENDER.get()).getTargetingColor(), radius * 3.0f), (double)entity.getX(), (double)(entity.getY() + (double)0.165f), (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ENDER.get()).getTargetingColor(), radius * 3.0f), (double)entity.getX(), (double)(entity.getY() + (double)0.165f), (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), radius * 3.0f), (double)entity.getX(), (double)(entity.getY() + (double)0.165f), (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), radius * 3.0f), (double)entity.getX(), (double)(entity.getY() + (double)0.165f), (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new ShockwaveParticleOptions(((SchoolType)SchoolRegistry.ENDER.get()).getTargetingColor(), -3.0f, true), (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        super.onServerPreCast(level, spellLevel, entity, playerMagicData);
        List entities = level.getEntities((Entity)entity, AABB.ofSize((Vec3)smiteLocation, (double)(radius * 2.0f), (double)(radius * 4.0f), (double)(radius * 2.0f)));
        SpellDamageSource damageSource = this.getDamageSource((Entity)entity);
        for (Entity targetEntity : entities) {
            if (!targetEntity.isAlive() || !targetEntity.isPickable() || !Utils.hasLineOfSight((Level)level, (Vec3)smiteLocation.add(0.0, 1.0, 0.0), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)false) || DamageSources.applyDamage((Entity)targetEntity, (float)this.getDamage(spellLevel, entity), (DamageSource)damageSource)) {
                // empty if block
            }
            CylinderParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)(100 * spellLevel), (ParticleOptions)ParticleHelper.PORTAL_FRAME, (ParticleDirection)ParticleDirection.UPWARD, (double)radius, (double)(4 * spellLevel), (double)-1.0);
            CylinderParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)100, (ParticleOptions)ParticleHelper.ELECTRIC_SPARKS, (ParticleDirection)ParticleDirection.INWARD, (double)15.0, (double)10.0, (double)2.0);
            super.onServerCastTick(level, spellLevel, entity, playerMagicData);
            CylinderParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)100, (ParticleOptions)ParticleHelper.FIERY_SPARKS, (ParticleDirection)ParticleDirection.INWARD, (double)15.0, (double)10.0, (double)2.0);
            super.onServerCastTick(level, spellLevel, entity, playerMagicData);
            CylinderParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)70, (ParticleOptions)ParticleHelper.VOID_TENTACLE_FOG, (ParticleDirection)ParticleDirection.OUTWARD, (double)15.0, (double)10.0, (double)3.0);
            super.onServerCastTick(level, spellLevel, entity, playerMagicData);
            CylinderParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)70, (ParticleOptions)ParticleHelper.COMET_FOG, (ParticleDirection)ParticleDirection.INWARD, (double)15.0, (double)10.0, (double)4.0);
            super.onServerCastTick(level, spellLevel, entity, playerMagicData);
        }
        entity.addEffect(new MobEffectInstance(ModEffectRegistry.STARBURNEDSOUL, 10000, 25));
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public SpellDamageSource getDamageSource(@Nullable Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setFreezeTicks(60);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity);
    }

    private float getRange(int spellLevel) {
        return 8.0f;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CAST_KNEELING_PRAYER;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.CAST_T_POSE;
    }
}

