/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.blood.uncraftable;

import com.gametechbc.spelllib.particle.ParticleDirection;
import com.gametechbc.spelllib.particle.SphereParticleManager;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.network.particles.ShockwaveParticlesPacket;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Optional;
import net.ender.endersequipment.registries.ModEffectRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3f;

@AutoSpellConfig
public class LordOfDecaySpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"lord_of_decay");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(1).setCooldownSeconds(210.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)(this.getSpellPower(spellLevel, (Entity)caster) * 16.0f), (int)1)}));
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public LordOfDecaySpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 35;
        this.spellPowerPerLevel = 0;
        this.castTime = 15;
        this.baseManaCost = 800;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.WITHER_SPAWN);
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.WITHER_DEATH);
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int radius = 6;
        Vector3f edge = new Vector3f(0.7f, 1.0f, 1.0f);
        Vector3f center = new Vector3f(1.0f, 1.0f, 1.0f);
        entity.addEffect(new MobEffectInstance(ModEffectRegistry.LORD_OF_DECAY, (int)(this.getSpellPower(spellLevel, (Entity)entity) * 16.0f), spellLevel - 1, false, false, true));
        SphereParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)40, (ParticleOptions)ParticleTypes.SCULK_SOUL, (ParticleDirection)ParticleDirection.OUTWARD, (double)8.0);
        SphereParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)40, (ParticleOptions)ParticleTypes.SOUL, (ParticleDirection)ParticleDirection.INWARD, (double)8.0);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(edge, (float)radius * 0.98f), (double)entity.getX(), (double)(entity.getY() + (double)0.15f), (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new ShockwaveParticlesPacket(new Vec3(entity.getX(), entity.getY() + (double)0.165f, entity.getZ()), (float)radius, (ParticleType)ParticleTypes.SOUL), (CustomPacketPayload[])new CustomPacketPayload[0]);
        level.getEntities((Entity)entity, entity.getBoundingBox().inflate((double)radius, 4.0, (double)radius), target -> !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)entity) && Utils.hasLineOfSight((Level)level, (Entity)entity, (Entity)target, (boolean)false)).forEach(target -> {
            LivingEntity livingEntity;
            if (target instanceof LivingEntity && (livingEntity = (LivingEntity)target).distanceToSqr((Entity)entity) < (double)(radius * radius)) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 180, 1));
                MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.SCULK_SOUL, (double)livingEntity.getX(), (double)(livingEntity.getY() + (double)(livingEntity.getBbHeight() * 0.5f)), (double)livingEntity.getZ(), (int)50, (double)(livingEntity.getBbWidth() * 0.5f), (double)(livingEntity.getBbHeight() * 0.5f), (double)(livingEntity.getBbWidth() * 0.5f), (double)0.03, (boolean)false);
            }
            super.onCast(level, spellLevel, entity, castSource, playerMagicData);
        });
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.SELF_CAST_ANIMATION;
    }
}

