/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.blood.divine;

import com.gametechbc.spelllib.particle.CylinderParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Optional;
import net.ender.endersequipment.registries.EEParticleRegistry;
import net.ender.endersequipment.registries.ModEffectRegistry;
import net.ender.endersequipment.registries.SoundRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

@AutoSpellConfig
public class TheDivinityOfAnubisSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"anubis");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(1).setCooldownSeconds(1000.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)(this.getSpellPower(spellLevel, (Entity)caster) * 30.0f), (int)1)}));
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.ANUBIS_SPELL_CAST.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.ANUBIS_DIVINITY_SPELL_END.get());
    }

    public TheDivinityOfAnubisSpell() {
        this.manaCostPerLevel = 30;
        this.baseSpellPower = 18;
        this.spellPowerPerLevel = 4;
        this.castTime = 50;
        this.baseManaCost = 50;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Vector3f edge = new Vector3f(0.7f, 1.0f, 1.0f);
        int radius = 3;
        entity.addEffect(new MobEffectInstance(ModEffectRegistry.ANUBIS_DIVINITY, (int)(this.getSpellPower(spellLevel, (Entity)entity) * 30.0f), spellLevel - 1, false, false, true));
        MagicManager.spawnParticles((Level)level, (ParticleOptions)((ParticleOptions)EEParticleRegistry.ANUBIS_ANKH.get()), (double)entity.getX(), (double)(entity.getY() + 1.0), (double)entity.getZ(), (int)80, (double)0.25, (double)0.25, (double)0.25, (double)(0.7f + (float)radius * 0.1f), (boolean)false);
        CylinderParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)(100 * spellLevel), (ParticleOptions)ParticleTypes.SCULK_SOUL, (ParticleDirection)ParticleDirection.UPWARD, (double)radius, (double)(4 * spellLevel), (double)-1.0);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(edge, (float)radius * 1.02f), (double)entity.getX(), (double)(entity.getY() + (double)0.15f), (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CAST_KNEELING_PRAYER;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SELF_CAST_TWO_HANDS;
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }
}

