/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.blood.divine;

import com.gametechbc.spelllib.particle.CylinderParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import com.gametechbc.spelllib.particle.SphereParticleManager;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.List;
import java.util.Optional;
import net.ender.endersequipment.registries.ModEffectRegistry;
import net.ender.endersequipment.registries.SoundRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

@AutoSpellConfig
public class JudgementScaleSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"judgement_scale");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(1).setCooldownSeconds(500.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}));
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.JUDGEMENT_SPELL_CAST.get());
    }

    public JudgementScaleSpell() {
        this.manaCostPerLevel = 30;
        this.baseSpellPower = 15;
        this.spellPowerPerLevel = 0;
        this.castTime = 25;
        this.baseManaCost = 250;
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)32, (float)0.35f);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (entity.hasEffect(ModEffectRegistry.ANUBIS_DIVINITY)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"ui.endersequipment.divine_status", (Object[])new Object[]{this.getDisplayName((Player)serverPlayer)}).withStyle(ChatFormatting.GOLD)));
                ICastData iCastData = playerMagicData.getAdditionalCastData();
                if (iCastData instanceof TargetEntityCastData) {
                    TargetEntityCastData targetData = (TargetEntityCastData)iCastData;
                    LivingEntity targetEntity = targetData.getTarget((ServerLevel)level);
                    float MAX_HEALTH = targetEntity.getMaxHealth();
                    float baseHealth = targetEntity.getHealth();
                    double percent = baseHealth / MAX_HEALTH * 100.0f;
                    if (percent >= 50.0) {
                        float radius = this.getRadius(spellLevel, entity);
                        float damage = this.getDamage(spellLevel, entity);
                        Vector3f edge = new Vector3f(0.7f, 1.0f, 1.0f);
                        float explosionRadius = 3.0f * (1.0f + 0.5f * targetEntity.getHealth() / targetEntity.getMaxHealth());
                        List entities = level.getEntities((Entity)targetEntity, targetEntity.getBoundingBox().inflate((double)explosionRadius));
                        CylinderParticleManager.spawnParticles((Level)level, (LivingEntity)targetEntity, (int)(100 * spellLevel), (ParticleOptions)ParticleTypes.SOUL, (ParticleDirection)ParticleDirection.UPWARD, (double)radius, (double)(2 * spellLevel), (double)-1.0);
                        SphereParticleManager.spawnParticles((Level)level, (LivingEntity)targetEntity, (int)80, (ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (ParticleDirection)ParticleDirection.INWARD, (double)8.0);
                        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
                        double distanceSqr = targetEntity.distanceToSqr(targetEntity.position());
                        if (distanceSqr < (double)(explosionRadius * explosionRadius) && Utils.hasLineOfSight((Level)level, (Vec3)targetEntity.getBoundingBox().getCenter(), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)false)) {
                            float p = (float)(distanceSqr / (double)(explosionRadius * explosionRadius));
                            p = 1.0f - p * p * p;
                            DamageSources.applyDamage((Entity)targetEntity, (float)(damage * p), (DamageSource)this.getDamageSource((Entity)targetEntity, (Entity)entity));
                        }
                        level.getEntities((Entity)entity, entity.getBoundingBox().inflate((double)radius, 4.0, (double)radius), target -> !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)entity) && Utils.hasLineOfSight((Level)level, (Entity)entity, (Entity)target, (boolean)true)).forEach(target -> {
                            LivingEntity livingEntity;
                            if (!(target instanceof LivingEntity) || (livingEntity = (LivingEntity)target).distanceToSqr((Entity)entity) < (double)(radius * radius)) {
                                // empty if block
                            }
                        });
                    } else {
                        float radius = this.getRadius(spellLevel, entity);
                        float damage = this.getDamage(spellLevel, entity);
                        float explosionRadius = 2.0f * (1.0f + 0.2f * targetEntity.getHealth() / targetEntity.getMaxHealth());
                        List entities = level.getEntities((Entity)targetEntity, targetEntity.getBoundingBox().inflate((double)explosionRadius));
                        double distanceSqr = targetEntity.distanceToSqr(targetEntity.position());
                        if (distanceSqr < (double)(explosionRadius * explosionRadius) && Utils.hasLineOfSight((Level)level, (Vec3)targetEntity.getBoundingBox().getCenter(), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)true)) {
                            float p = (float)(distanceSqr / (double)(explosionRadius * explosionRadius));
                            p = 1.0f - p * p * p;
                            DamageSources.applyDamage((Entity)targetEntity, (float)(damage * p * 0.4f), (DamageSource)this.getDamageSource((Entity)targetEntity, (Entity)entity));
                        }
                        level.getEntities((Entity)entity, entity.getBoundingBox().inflate((double)radius, 4.0, (double)radius), target -> !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)entity) && Utils.hasLineOfSight((Level)level, (Entity)entity, (Entity)target, (boolean)true)).forEach(target -> {
                            LivingEntity livingEntity;
                            if (!(target instanceof LivingEntity) || (livingEntity = (LivingEntity)target).distanceToSqr((Entity)entity) < (double)(radius * radius)) {
                                // empty if block
                            }
                        });
                    }
                }
            }
        } else if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"ui.endersequipment.no_divine_status", (Object[])new Object[]{this.getDisplayName((Player)serverPlayer)}).withStyle(ChatFormatting.RED)));
        }
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public float getRadius(int spellLevel, LivingEntity caster) {
        return 5.0f + (float)spellLevel * 0.5f;
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity);
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }
}

