/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.blood;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.ender.endersequipment.registries.ModEffectRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class HeartwrenchSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"heartwrench");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(10).setCooldownSeconds(85.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)(this.getSpellPower(spellLevel, (Entity)caster) * 10.0f), (int)1)}), Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}));
    }

    public HeartwrenchSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 3;
        this.castTime = 15;
        this.baseManaCost = 55;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.HEARTSTOP_CAST.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.DARK_MAGIC_BUFF_03_CUSTOM_1.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)32, (float)0.35f);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData) {
            TargetEntityCastData targetData = (TargetEntityCastData)iCastData;
            LivingEntity targetEntity = targetData.getTarget((ServerLevel)level);
            float radius = this.getRadius(spellLevel, entity);
            float damage = this.getDamage(spellLevel, entity);
            float explosionRadius = 3.0f * (1.0f + 0.5f * targetEntity.getHealth() / targetEntity.getMaxHealth());
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.BLOOD, (double)targetEntity.getX(), (double)(targetEntity.getY() + 0.25), (double)targetEntity.getZ(), (int)100, (double)0.03, (double)0.4, (double)0.03, (double)0.4, (boolean)true);
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.BLOOD, (double)targetEntity.getX(), (double)(targetEntity.getY() + 0.25), (double)targetEntity.getZ(), (int)100, (double)0.03, (double)0.4, (double)0.03, (double)0.4, (boolean)false);
            MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.BLOOD.get()).getTargetingColor(), explosionRadius), (double)targetEntity.getX(), (double)targetEntity.getBoundingBox().getCenter().y, (double)targetEntity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            double distanceSqr = targetEntity.distanceToSqr(targetEntity.position());
            if (distanceSqr < (double)(explosionRadius * explosionRadius) && Utils.hasLineOfSight((Level)level, (Vec3)targetEntity.getBoundingBox().getCenter(), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)true)) {
                float p = (float)(distanceSqr / (double)(explosionRadius * explosionRadius));
                p = 1.0f - p * p * p;
                DamageSources.applyDamage((Entity)targetEntity, (float)(damage * p), (DamageSource)this.getDamageSource((Entity)targetEntity, (Entity)entity));
                targetEntity.addEffect(new MobEffectInstance(ModEffectRegistry.HEARTWRENCHED, (int)(this.getSpellPower(spellLevel, (Entity)entity) * 10.0f), 1, false, false, true));
            }
            level.getEntities((Entity)entity, entity.getBoundingBox().inflate((double)radius, 4.0, (double)radius), target -> !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)entity) && Utils.hasLineOfSight((Level)level, (Entity)entity, (Entity)target, (boolean)true)).forEach(target -> {
                LivingEntity livingEntity;
                if (target instanceof LivingEntity && (livingEntity = (LivingEntity)target).distanceToSqr((Entity)entity) < (double)(radius * radius)) {
                    int i = this.getDuration(this.baseSpellPower, entity) / 2;
                    livingEntity.addEffect(new MobEffectInstance(ModEffectRegistry.HEARTWRENCHED, i, 1));
                    MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.BLOOD_GROUND, (double)livingEntity.getX(), (double)(livingEntity.getY() + (double)(livingEntity.getBbHeight() * 0.5f)), (double)livingEntity.getZ(), (int)50, (double)(livingEntity.getBbWidth() * 0.5f), (double)(livingEntity.getBbHeight() * 0.5f), (double)(livingEntity.getBbWidth() * 0.5f), (double)0.03, (boolean)false);
                }
            });
            CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(10, targetEntity.position(), 20.0f));
        }
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return 2.0f + this.getSpellPower(spellLevel, (Entity)caster) / 3.0f;
    }

    public int getDuration(int spellLevel, LivingEntity caster) {
        return (int)(this.getSpellPower(spellLevel, (Entity)caster) * 8.0f);
    }

    public float getRadius(int spellLevel, LivingEntity caster) {
        return 5.0f + (float)spellLevel * 0.5f;
    }

    public int getWrenchAmplifier(int spellLevel, LivingEntity caster) {
        return 0;
    }
}

