/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.blade;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import java.util.List;
import javax.annotation.Nullable;
import net.ender.endersequipment.registries.EESchoolRegistry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

@AutoSpellConfig
public class QuickSliceSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"quick_slice");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(EESchoolRegistry.BLADE_RESOURCE).setMaxLevel(5).setCooldownSeconds(20.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{this.getDamageText(spellLevel, caster)}), Component.translatable((String)"ui.irons_spellbooks.distance", (Object[])new Object[]{Utils.stringTruncation((double)this.getRange(spellLevel, caster), (int)1)}));
    }

    public QuickSliceSpell() {
        this.manaCostPerLevel = 12;
        this.baseSpellPower = 4;
        this.spellPowerPerLevel = 2;
        this.castTime = 5;
        this.baseManaCost = 90;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData) {
            TargetEntityCastData targetEntityCastData = (TargetEntityCastData)iCastData;
            LivingEntity targetEntity = targetEntityCastData.getTarget((ServerLevel)level);
            if (targetEntity != null) {
                Vec3 targetPosition = targetEntity.position();
                entity.teleportTo(targetPosition.x, targetPosition.y, targetPosition.z);
            }
            float radius = 3.0f;
            float range = 2.0f;
            Vec3 smiteLocation = Utils.raycastForBlock((Level)level, (Vec3)entity.getEyePosition(), (Vec3)entity.getEyePosition().add(entity.getForward().multiply((double)range, 0.0, (double)range)), (ClipContext.Fluid)ClipContext.Fluid.NONE).getLocation();
            Vec3 particleLocation = level.clip(new ClipContext(smiteLocation, smiteLocation.add(0.0, -2.0, 0.0), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty())).getLocation().add(0.0, 0.1, 0.0);
            CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(10, particleLocation, 10.0f));
            List entities = level.getEntities((Entity)entity, AABB.ofSize((Vec3)smiteLocation, (double)radius, (double)radius, (double)radius));
            SpellDamageSource damageSource = this.getDamageSource((Entity)entity);
            if (targetEntity.isAlive() && targetEntity.isPickable() && Utils.hasLineOfSight((Level)level, (Vec3)smiteLocation.add(0.0, 1.0, 0.0), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)true) && DamageSources.applyDamage((Entity)targetEntity, (float)this.getDamage(spellLevel, entity), (DamageSource)damageSource)) {
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)level), (Entity)targetEntity, (DamageSource)damageSource);
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onClientPreCast(Level level, int spellLevel, LivingEntity entity, InteractionHand hand, @Nullable MagicData playerMagicData) {
        super.onClientPreCast(level, spellLevel, entity, hand, playerMagicData);
        Vec3 forward = entity.getForward().normalize();
        for (int i = 0; i < 35; ++i) {
            Vec3 motion = forward.scale(Utils.random.nextDouble() * 0.25);
            level.addParticle((ParticleOptions)ParticleTypes.CRIT, entity.getRandomX((double)0.4f), entity.getRandomY(), entity.getRandomZ((double)0.4f), motion.x, motion.y, motion.z);
        }
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)(15 + spellLevel), (float)0.35f);
    }

    public float getRange(int spellLevel, LivingEntity caster) {
        return 15 + spellLevel;
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) * 0.1f + this.getWeaponDamage(entity);
    }

    private float getWeaponDamage(LivingEntity entity) {
        if (entity == null) {
            return 0.0f;
        }
        float weaponDamage = Utils.getWeaponDamage((LivingEntity)entity);
        ItemStack weaponItem = entity.getWeaponItem();
        if (!weaponItem.isEmpty() && weaponItem.has(DataComponents.ENCHANTMENTS)) {
            weaponDamage += Utils.processEnchantment((Level)entity.level(), (ResourceKey)Enchantments.SHARPNESS, (DataComponentType)EnchantmentEffectComponents.DAMAGE, (ItemEnchantments)((ItemEnchantments)weaponItem.get(DataComponents.ENCHANTMENTS)));
        }
        return weaponDamage;
    }

    private String getDamageText(int spellLevel, LivingEntity entity) {
        if (entity != null) {
            float weaponDamage = Utils.getWeaponDamage((LivingEntity)entity);
            String plus = "";
            if (weaponDamage > 0.0f) {
                plus = String.format(" (+%s)", Utils.stringTruncation((double)weaponDamage, (int)1));
            }
            String damage = Utils.stringTruncation((double)this.getDamage(spellLevel, entity), (int)1);
            return damage + plus;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)entity);
    }
}

