/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.blade;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.ender.endersequipment.entity.spells.flurry.BigFlurryProjectile;
import net.ender.endersequipment.entity.spells.flurry.SmallFlurryProjectile;
import net.ender.endersequipment.registries.EESchoolRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class FlurrySpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"flurry");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(EESchoolRegistry.BLADE_RESOURCE).setMaxLevel(5).setCooldownSeconds(60.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{this.getDamageText(spellLevel, caster)}));
    }

    public FlurrySpell() {
        this.manaCostPerLevel = 22;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 2;
        this.castTime = 5;
        this.baseManaCost = 90;
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 3;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 80, castSource, null), playerMagicData);
        }
        float radius = 3.25f;
        float distance = 1.9f;
        Vec3 forward = entity.getForward();
        Vec3 hitLocation = entity.position().add(0.0, (double)(entity.getBbHeight() * 0.3f), 0.0).add(forward.scale((double)distance));
        List entities = level.getEntities((Entity)entity, AABB.ofSize((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        SpellDamageSource damageSource = this.getDamageSource((Entity)entity);
        for (Entity targetEntity : entities) {
            Vec3 offsetVector;
            if (!(targetEntity instanceof LivingEntity) || !targetEntity.isAlive() || !entity.isPickable() || !(targetEntity.position().subtract(entity.getEyePosition()).dot(forward) >= 0.0) || !(entity.distanceToSqr(targetEntity) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.getEyePosition(), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)true) || !((offsetVector = targetEntity.getBoundingBox().getCenter().subtract(entity.getEyePosition())).dot(forward) >= 0.0) || !DamageSources.applyDamage((Entity)targetEntity, (float)this.getDamage(spellLevel, entity), (DamageSource)damageSource)) continue;
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.END_ROD, (double)targetEntity.getX(), (double)(targetEntity.getY() + (double)(targetEntity.getBbHeight() * 0.5f)), (double)targetEntity.getZ(), (int)30, (double)(targetEntity.getBbWidth() * 0.5f), (double)(targetEntity.getBbHeight() * 0.5f), (double)(targetEntity.getBbWidth() * 0.5f), (double)0.03, (boolean)false);
        }
        boolean mirrored = playerMagicData.getCastingEquipmentSlot().equals(SpellSelectionManager.OFFHAND);
        SmallFlurryProjectile wave = new SmallFlurryProjectile(level, entity);
        wave.setPos(entity.position().add(0.0, (double)entity.getEyeHeight() - wave.getBoundingBox().getYsize() * 0.5, 0.0));
        wave.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYHeadRot(), 0.0f, wave.getSpeed(), 1.0f);
        wave.setDamage(this.getDamage(spellLevel, entity));
        level.addFreshEntity((Entity)wave);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        if (recastResult == RecastResult.USED_ALL_RECASTS) {
            Level level = serverPlayer.level();
            this.shootBigSlash((LivingEntity)serverPlayer, level);
        }
        super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
    }

    private void shootBigSlash(LivingEntity entity, Level level) {
        BigFlurryProjectile wave = new BigFlurryProjectile(level, entity);
        wave.setPos(entity.position().add(0.0, (double)entity.getEyeHeight() - wave.getBoundingBox().getYsize() * 0.5, 0.0));
        wave.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYHeadRot(), 0.0f, wave.getSpeed(), 1.0f);
        int spellLevel = this.spellPowerPerLevel;
        wave.setDamage(this.getDamage(spellLevel, entity));
        level.addFreshEntity((Entity)wave);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return (float)((double)this.getSpellPower(spellLevel, (Entity)caster) * 0.6 + (double)this.getWeaponDamage(caster));
    }

    private float getWeaponDamage(LivingEntity caster) {
        float weaponDamage = Utils.getWeaponDamage((LivingEntity)caster);
        return weaponDamage;
    }

    private String getDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float weaponDamage = Utils.getWeaponDamage((LivingEntity)caster);
            String plus = "";
            if (weaponDamage > 0.0f) {
                plus = String.format(" (+%s)", Utils.stringTruncation((double)weaponDamage, (int)1));
            }
            String damage = Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1);
            return damage + plus;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ONE_HANDED_HORIZONTAL_SWING_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.DEAD_KING_SLAM.get());
    }
}

