/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.spells.blade;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.Optional;
import net.ender.endersequipment.registries.EESchoolRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class FinalBreathSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"final_breath");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(EESchoolRegistry.BLADE_RESOURCE).setMaxLevel(1).setCooldownSeconds(90.0).build();

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.SELF_CAST_TWO_HANDS;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.DEAD_KING_SLAM.get());
    }

    public FinalBreathSpell() {
        this.manaCostPerLevel = 100;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 2;
        this.castTime = 5;
        this.baseManaCost = 85;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float MAX_HEALTH = entity.getMaxHealth();
        float baseHealth = entity.getHealth();
        double percent = baseHealth / MAX_HEALTH * 100.0f;
        if (percent <= 40.0) {
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, (int)(this.getSpellPower(spellLevel, (Entity)entity) * 40.0f), 1, false, false, true));
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, (int)(this.getSpellPower(spellLevel, (Entity)entity) * 40.0f), 4, false, false, true));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, (int)(this.getSpellPower(spellLevel, (Entity)entity) * 40.0f), 2, false, false, true));
            entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, (int)(this.getSpellPower(spellLevel, (Entity)entity) * 40.0f), 0, false, false, true));
        } else if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"ui.endersequipment.final_breath_failed", (Object[])new Object[]{this.getDisplayName((Player)serverPlayer)}).withStyle(ChatFormatting.RED)));
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }
}

