/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.registries;

import io.redspace.ironsspellbooks.api.attribute.MagicPercentAttribute;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="endersequipment", bus=EventBusSubscriber.Bus.MOD)
public class EEAttributeRegistry {
    private static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"endersequipment");
    public static final DeferredHolder<Attribute, Attribute> BLADE_SPELL_POWER = EEAttributeRegistry.newPowerAttribute("spellblade");
    public static final DeferredHolder<Attribute, Attribute> BLADE_MAGIC_RESIST = EEAttributeRegistry.newResistanceAttribute("spellblade");

    public static void register(IEventBus eventBus) {
        ATTRIBUTES.register(eventBus);
    }

    @SubscribeEvent
    public static void modifyEntityAttributes(EntityAttributeModificationEvent e) {
        e.getTypes().forEach(entity -> ATTRIBUTES.getEntries().forEach(attribute -> e.add(entity, (Holder)attribute)));
    }

    private static DeferredHolder<Attribute, Attribute> newResistanceAttribute(String id) {
        return ATTRIBUTES.register(id + "_magic_resist", () -> new MagicPercentAttribute("attribute.irons_spellbooks." + id + "_magic_resist", 1.0, -100.0, 100.0).setSyncable(true));
    }

    private static DeferredHolder<Attribute, Attribute> newPowerAttribute(String id) {
        return ATTRIBUTES.register(id + "_spell_power", () -> new MagicPercentAttribute("attribute.irons_spellbooks." + id + "_spell_power", 1.0, -100.0, 100.0).setSyncable(true));
    }
}

