/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.events;

import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import net.ender.endersequipment.item.swordtiers.bloodthirst;
import net.ender.endersequipment.registries.ModEffectRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber
public class ModEvents {
    @SubscribeEvent
    public static void livingDamageEvent(LivingDamageEvent.Post event) {
        LivingEntity livingEntity;
        ItemStack mainhandItem;
        Entity sourceEntity = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        Entity projectile = event.getSource().getDirectEntity();
        if (sourceEntity instanceof LivingEntity && (mainhandItem = (livingEntity = (LivingEntity)sourceEntity).getMainHandItem()).getItem() instanceof bloodthirst && target instanceof LivingEntity) {
            LivingEntity livingTarget = target;
            livingTarget.addEffect(new MobEffectInstance(ModEffectRegistry.BLOODIEDWOUNDSEFFECT, 60, 0));
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        IMagicSummon summon;
        if (event.getEntity() instanceof IMagicSummon && (summon = (IMagicSummon)event.getEntity()).getSummoner() != null && summon.getSummoner() instanceof ServerPlayer) {
            ServerPlayer summoner = (ServerPlayer)summon.getSummoner();
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)summoner);
            if (summoner.hasEffect(ModEffectRegistry.LORD_OF_DECAY) && magicData.getMana() > 50.0f) {
                magicData.setMana(magicData.getMana() - 50.0f);
                summoner.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.ITALIC) + "Revived Summon")).withStyle(s -> s.withColor(TextColor.fromRgb((int)0x323232))), true);
                event.setCanceled(true);
                event.getEntity().setHealth(event.getEntity().getMaxHealth());
                if (event.getSource().getEntity() instanceof LivingEntity) {
                    // empty if block
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath2(LivingDeathEvent event) {
        IMagicSummon summon;
        if (event.getEntity() instanceof IMagicSummon && (summon = (IMagicSummon)event.getEntity()).getSummoner() != null && summon.getSummoner() instanceof ServerPlayer) {
            ServerPlayer summoner = (ServerPlayer)summon.getSummoner();
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)summoner);
            if (summoner.hasEffect(ModEffectRegistry.ANUBIS_DIVINITY) && magicData.getMana() > 0.0f) {
                summoner.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + "Loyal Minion Returned from Death")).withStyle(s -> s.withColor(TextColor.fromRgb((int)0x323232))), true);
                event.setCanceled(true);
                event.getEntity().addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 150, 1));
                event.getEntity().setHealth(event.getEntity().getMaxHealth());
                if (event.getSource().getEntity() instanceof LivingEntity) {
                    // empty if block
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCastEvent(SpellPreCastEvent event) {
        Player entity = event.getEntity();
        boolean hasEbonyEffect = entity.hasEffect(ModEffectRegistry.EBONY_ARMOR);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && hasEbonyEffect) {
                event.setCanceled(true);
                int time = player.getEffect(ModEffectRegistry.EBONY_ARMOR).getDuration();
                String formattedTime = ModEvents.convertTicksToTime(time);
                player.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.BOLD) + "The Curse Prevents you from casting for : " + formattedTime)).withStyle(s -> s.withColor(TextColor.fromRgb((int)0x323232))), true);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WITHER_HURT, SoundSource.PLAYERS, 0.3f, 1.0f);
            }
        }
    }

    public static String convertTicksToTime(int ticks) {
        int totalSeconds = ticks / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    @SubscribeEvent
    public static void onPlayerLivingDamage1(LivingDamageEvent.Post event) {
        ServerPlayer livingAttacker;
        LivingEntity attacked = event.getEntity();
        Entity attacker = event.getSource().getDirectEntity();
        LivingEntity entity = event.getEntity();
        LivingEntity ServerEntity = event.getEntity();
        if (attacker instanceof ServerPlayer && (livingAttacker = (ServerPlayer)attacker).hasEffect(ModEffectRegistry.BLESSEDEFFECT)) {
            ((AbstractSpell)SpellRegistry.SUNBEAM_SPELL.get()).castSpell(event.getEntity().level(), 5, (ServerPlayer)attacker, CastSource.SCROLL, true);
            ((AbstractSpell)SpellRegistry.ANGEL_WINGS_SPELL.get()).castSpell(event.getEntity().level(), 3, livingAttacker, CastSource.SCROLL, true);
        }
    }

    @SubscribeEvent
    public static void onPlayerLivingDamage(LivingDamageEvent.Post event) {
        ServerPlayer livingAttacker;
        LivingEntity attacked = event.getEntity();
        Entity attacker = event.getSource().getDirectEntity();
        LivingEntity entity = event.getEntity();
        LivingEntity ServerEntity = event.getEntity();
        if (attacker instanceof ServerPlayer && (livingAttacker = (ServerPlayer)attacker).hasEffect(ModEffectRegistry.OVERCHARGED)) {
            ((AbstractSpell)SpellRegistry.BALL_LIGHTNING_SPELL.get()).castSpell(event.getEntity().level(), 5, (ServerPlayer)attacker, CastSource.SCROLL, true);
        }
    }

    @SubscribeEvent
    public static void BlizzardArmor(LivingDamageEvent.Pre event) {
        LivingEntity attacked = event.getEntity();
        Entity attacker = event.getSource().getDirectEntity();
        if (attacked.hasEffect(ModEffectRegistry.BLIZARDARMOR)) {
            attacker.setTicksFrozen(160);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Post event) {
        LivingEntity livingAttacker;
        LivingEntity attacked = event.getEntity();
        Entity attacker = event.getSource().getDirectEntity();
        LivingEntity entity = event.getEntity();
        LivingEntity ServerEntity = event.getEntity();
        if (attacker instanceof LivingEntity && (livingAttacker = (LivingEntity)attacker).hasEffect(ModEffectRegistry.BLESSEDEFFECT)) {
            attacked.addEffect(new MobEffectInstance(ModEffectRegistry.BLOODIEDWOUNDSEFFECT));
        }
    }

    @SubscribeEvent
    public static void onLivingDamage2(LivingDamageEvent.Post event) {
        LivingEntity livingAttacker;
        LivingEntity attacked = event.getEntity();
        Entity attacker = event.getSource().getDirectEntity();
        LivingEntity entity = event.getEntity();
        LivingEntity ServerEntity = event.getEntity();
        if (attacker instanceof LivingEntity && (livingAttacker = (LivingEntity)attacker).hasEffect(ModEffectRegistry.WITHERING_TOUCH)) {
            attacked.addEffect(new MobEffectInstance(MobEffects.WITHER, 80, 2));
        }
    }

    @SubscribeEvent
    public static void livingDamageEvent2(LivingDamageEvent.Post event) {
        Entity sourceEntity = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().getDirectEntity();
        LivingEntity attacked = event.getEntity();
        Entity projectile = event.getSource().getDirectEntity();
        if (sourceEntity != null && sourceEntity instanceof Player) {
            LivingEntity livingAttacker;
            Player player = (Player)sourceEntity;
            if (projectile instanceof Projectile && attacker instanceof LivingEntity && (livingAttacker = (LivingEntity)attacker).hasEffect(ModEffectRegistry.WITHERING_TOUCH)) {
                attacked.addEffect(new MobEffectInstance(MobEffects.WITHER, 80, 2));
            }
        }
    }
}

