/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.entity.spells.pale_flame;

import java.util.Optional;
import net.ender.endersequipment.entity.spells.pale_flame.PaleFlame;
import net.ender.endersequipment.registries.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PaleFlame60
extends PaleFlame {
    private static final EntityDataAccessor<Boolean> DATA_MIRRORED = SynchedEntityData.defineId(PaleFlame60.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    LivingEntity target;
    public final int ticksPerFrame = 2;
    public final int deathTime = 8;

    public PaleFlame60(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PaleFlame60(Level level, boolean mirrored) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.PALE_FLAME_60.get()), level);
        if (mirrored) {
            this.getEntityData().set(DATA_MIRRORED, (Object)true);
        }
    }

    @Override
    public void applyEffect(LivingEntity target) {
        new MobEffectInstance(MobEffects.BLINDNESS, 150, 2);
        new MobEffectInstance(MobEffects.GLOWING, 150, 2);
    }

    @Override
    public void tick() {
        if (!this.firstTick) {
            this.firstTick = true;
        }
        if (this.tickCount >= 8) {
            this.discard();
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_MIRRORED, (Object)false);
    }

    @Override
    public boolean isMirrored() {
        return (Boolean)this.getEntityData().get(DATA_MIRRORED);
    }

    @Override
    public boolean shouldBeSaved() {
        return false;
    }

    @Override
    public void refreshDimensions() {
    }

    @Override
    public void ambientParticles() {
    }

    @Override
    public float getParticleCount() {
        return 0.0f;
    }

    @Override
    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket pPacket) {
        super.recreateFromPacket(pPacket);
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    @Override
    protected Vec3 getInflation() {
        return Vec3.ZERO;
    }
}

