/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.entity.spells.holy_wave;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.ender.endersequipment.entity.spells.holy_wave.HolyWaveProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class HolyWaveRenderer
extends EntityRenderer<HolyWaveProjectile> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"endersequipment", (String)"textures/entity/spells/holy_wave1.png")};

    public HolyWaveRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(HolyWaveProjectile wave, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        PoseStack.Pose pose = poseStack.last();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)wave.yRotO, (float)wave.getYRot())));
        poseStack.mulPose(Axis.XP.rotationDegrees(-Mth.lerp((float)partialTick, (float)wave.xRotO, (float)wave.getXRot())));
        float randomZ = new Random(31L * (long)wave.getId()).nextInt(-8, 8);
        poseStack.mulPose(Axis.XP.rotationDegrees(randomZ));
        this.createSlashTexture(pose, wave, bufferSource, wave.getBbWidth() * 1.1f);
        poseStack.popPose();
        super.render((Entity)wave, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    private void createSlashTexture(PoseStack.Pose pose, HolyWaveProjectile wave, MultiBufferSource bufferSource, float width) {
        Matrix4f poseMatrix = pose.pose();
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(wave)));
        float halfWidth = width * 0.2f;
        float height = wave.getBbHeight() * 0.5f;
        consumer.addVertex(poseMatrix, -halfWidth, height, -halfWidth).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(poseMatrix, halfWidth, height, -halfWidth).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(poseMatrix, halfWidth, height, halfWidth).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(poseMatrix, -halfWidth, height, halfWidth).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull HolyWaveProjectile wave) {
        int frame = 0;
        return TEXTURES[frame];
    }
}

