/*
 * Decompiled with CFR 0.152.
 */
package net.ender.endersequipment.entity.spells.flurry;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.entity.spells.AbstractShieldEntity;
import io.redspace.ironsspellbooks.entity.spells.ShieldPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.ender.endersequipment.registries.EntityRegistry;
import net.ender.endersequipment.registries.SpellRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BigFlurryProjectile
extends AbstractMagicProjectile
implements AntiMagicSusceptible {
    private List<Entity> entities = new ArrayList<Entity>();

    public BigFlurryProjectile(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public BigFlurryProjectile(EntityType<? extends Projectile> entityType, Level level, LivingEntity shooter) {
        this(entityType, level);
        this.setOwner((Entity)shooter);
        this.setYRot(shooter.getYRot());
        this.setXRot(shooter.getXRot());
    }

    public BigFlurryProjectile(Level level, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.BIG_FLURRY_WAVE.get()), level, shooter);
    }

    public void travel() {
        this.setPos(this.position().add(this.getDeltaMovement()));
        if (!this.isNoGravity()) {
            Vec3 vec3 = this.getDeltaMovement();
            this.setDeltaMovement(vec3.x, vec3.y - (double)0.05f, vec3.z);
        }
    }

    public void tick() {
        if (!this.level().isClientSide) {
            HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
            if (hitresult.getType() == HitResult.Type.BLOCK) {
                this.onHitBlock((BlockHitResult)hitresult);
            }
            for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox()).stream().filter(target -> this.canHitEntity((Entity)target) && !this.entities.contains(target)).collect(Collectors.toSet())) {
                this.damageEntity(entity);
            }
        }
        Vec3 deltaMovement = this.getDeltaMovement();
        double distance = deltaMovement.horizontalDistance();
        double x = deltaMovement.x;
        double y = deltaMovement.y;
        double z = deltaMovement.z;
        this.setYRot((float)(Mth.atan2((double)x, (double)z) * 57.29577951308232));
        this.setXRot((float)(Mth.atan2((double)y, (double)distance) * 57.29577951308232));
        this.setXRot(BigFlurryProjectile.lerpRotation((float)this.xRotO, (float)this.getXRot()));
        this.setYRot(BigFlurryProjectile.lerpRotation((float)this.yRotO, (float)this.getYRot()));
        super.tick();
    }

    public void trailParticles() {
        Vec3 vec3 = this.position().subtract(this.getDeltaMovement());
        this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANTED_HIT, vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.ENCHANTED_HIT, (double)x, (double)y, (double)z, (int)75, (double)0.1, (double)0.1, (double)0.1, (double)2.0, (boolean)true);
    }

    public float getSpeed() {
        return 1.5f;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    private void damageEntity(Entity entity) {
        if (!this.entities.contains(entity)) {
            DamageSources.applyDamage((Entity)entity, (float)this.damage, (DamageSource)SpellRegistry.FLURRY.get().getDamageSource((Entity)this, this.getOwner()));
            if (entity instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)entity;
                if (livingTarget instanceof Player) {
                    Player player = (Player)livingTarget;
                    player.disableShield();
                }
                if (DamageSources.applyDamage((Entity)livingTarget, (float)this.damage, (DamageSource)SpellRegistry.FLURRY.get().getDamageSource((Entity)this, this.getOwner()))) {
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)this.level()), (Entity)livingTarget, (DamageSource)SpellRegistry.FLURRY.get().getDamageSource((Entity)this, this.getOwner()));
                }
            }
            if (entity instanceof ShieldPart || entity instanceof AbstractShieldEntity) {
                entity.kill();
            }
            this.entities.add(entity);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    protected boolean canHitEntity(Entity pTarget) {
        return pTarget != this.getOwner() && super.canHitEntity(pTarget);
    }

    public Optional<Holder<SoundEvent>> getImpactSound() {
        return Optional.empty();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void onAntiMagic(MagicData playerMagicData) {
        this.discard();
    }
}

