/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.util;

import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.core.BlockStateFTBC;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class HeightUtils {
    public static final int UNKNOWN = -32767;

    public static boolean isWater(BlockState state) {
        boolean bl;
        if (state == null) {
            return false;
        }
        if (state.getBlock() == Blocks.WATER) {
            return true;
        }
        if (state instanceof BlockStateFTBC) {
            BlockStateFTBC ftbc = (BlockStateFTBC)state;
            bl = ftbc.getFTBCIsWater();
        } else {
            bl = state.getFluidState().getType().isSame((Fluid)Fluids.WATER);
        }
        return bl;
    }

    public static boolean skipBlock(Level level, BlockState state) {
        if (level.isClientSide) {
            return state.isAir() || FTBChunksClient.INSTANCE.skipBlock(state);
        }
        return false;
    }

    public static int getHeight(Level level, @Nullable ChunkAccess chunkAccess, BlockPos.MutableBlockPos pos) {
        if (chunkAccess == null) {
            return -32767;
        }
        int bottomY = chunkAccess.getMinBuildHeight();
        int topY = pos.getY();
        boolean hasCeiling = level.dimensionType().hasCeiling();
        int currentWaterY = -32767;
        block0: for (int by = topY; by >= bottomY; --by) {
            boolean water;
            pos.setY(by);
            BlockState state = chunkAccess.getBlockState((BlockPos)pos);
            if (hasCeiling && (by == topY || state.getBlock() == Blocks.BEDROCK)) {
                while (by > bottomY) {
                    pos.setY(by);
                    state = chunkAccess.getBlockState((BlockPos)pos);
                    if (HeightUtils.skipBlock(level, state)) continue block0;
                    --by;
                }
            }
            if ((water = HeightUtils.isWater(state)) && currentWaterY == -32767) {
                currentWaterY = by;
            }
            if (water || HeightUtils.skipBlock(level, state)) continue;
            return currentWaterY;
        }
        pos.setY(-32767);
        return -32767;
    }
}

