/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.items.component.BottleBlood;
import java.util.List;
import java.util.Random;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class SetBloodFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetBloodFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> SetBloodFunction.commonFields((RecordCodecBuilder.Instance)inst).and((App)Codec.INT.fieldOf("minBlood").forGetter(function -> function.minBlood)).and((App)Codec.INT.fieldOf("maxBlood").forGetter(function -> function.maxBlood)).apply((Applicative)inst, SetBloodFunction::new));
    public final int minBlood;
    public final int maxBlood;

    @NotNull
    public static LootItemConditionalFunction.Builder<?> builder(int minBlood, int maxBlood) {
        return SetBloodFunction.simpleBuilder(conditions -> new SetBloodFunction((List<LootItemCondition>)conditions, minBlood, maxBlood));
    }

    @NotNull
    public static LootItemConditionalFunction.Builder<?> builder(int blood) {
        return SetBloodFunction.simpleBuilder(conditions -> new SetBloodFunction((List<LootItemCondition>)conditions, blood, blood));
    }

    protected SetBloodFunction(List<LootItemCondition> predicates, int minBlood, int maxBlood) {
        super(predicates);
        this.minBlood = minBlood;
        this.maxBlood = maxBlood;
    }

    @NotNull
    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return (LootItemFunctionType)ModLoot.SET_BLOOD.get();
    }

    @NotNull
    protected ItemStack run(@NotNull ItemStack stack, @NotNull LootContext context) {
        stack.set((DataComponentType)ModDataComponents.BOTTLE_BLOOD.get(), (Object)new BottleBlood(new Random().nextInt(this.minBlood, this.maxBlood + 1)));
        return stack;
    }
}

