/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structure.templatesystem;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.core.ModStructures;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomeTopBlockProcessor
extends StructureProcessor {
    public static final MapCodec<BiomeTopBlockProcessor> CODEC = BlockState.CODEC.fieldOf("replace_block").xmap(BiomeTopBlockProcessor::new, entry -> entry.replaceBlock);
    private static final Map<Block, Block> streetBlocks = new HashMap<Block, Block>(){
        {
            this.put(Blocks.SAND, Blocks.SMOOTH_SANDSTONE);
            this.put(Blocks.GRASS_BLOCK, Blocks.DIRT_PATH);
        }
    };
    private final BlockState replaceBlock;

    public BiomeTopBlockProcessor(BlockState blockState) {
        this.replaceBlock = blockState;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(@NotNull LevelReader worldReaderIn, @NotNull BlockPos pos, @NotNull BlockPos pos1, @NotNull StructureTemplate.StructureBlockInfo blockInfo, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull StructureTemplate.StructureBlockInfo blockInfo1, @NotNull StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        if (blockInfo1.state().equals(this.replaceBlock)) {
            BlockState topBlock = worldReaderIn.getBlockState(blockInfo1.pos());
            if (streetBlocks.containsKey(topBlock.getBlock())) {
                topBlock = streetBlocks.get(topBlock.getBlock()).defaultBlockState();
            }
            return new StructureTemplate.StructureBlockInfo(blockInfo1.pos(), topBlock, null);
        }
        return blockInfo1;
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)ModStructures.BIOME_BASED.get();
    }
}

