/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.biome;

import de.teamlapen.vampirism.api.VEnums;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.world.gen.VampirismFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.NotNull;

public class VampirismBiomes {
    @NotNull
    public static Biome createVampireForest(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        mobSpawnBuilder.creatureGenerationProbability(0.25f);
        mobSpawnBuilder.addSpawn((MobCategory)VEnums.VAMPIRE_CATEGORY.getValue(), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.VAMPIRE.get(), 80, 1, 3));
        mobSpawnBuilder.addSpawn((MobCategory)VEnums.VAMPIRE_CATEGORY.getValue(), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.VAMPIRE_BARON.get(), 27, 1, 1));
        mobSpawnBuilder.addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.BLINDING_BAT.get(), 60, 2, 4));
        mobSpawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.DUMMY_CREATURE.get(), 80, 3, 6));
        BiomeSpecialEffects.Builder biomeSpecialEffectsBuilder = new BiomeSpecialEffects.Builder().waterColor(6752023).waterFogColor(6752023).fogColor(0x171717).skyColor(0x131313).foliageColorOverride(0x101010).grassColorOverride(0x101010).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_CRIMSON_FOREST_MOOD, 6000, 8, 2.0)).ambientAdditionsSound(new AmbientAdditionsSettings((Holder)SoundEvents.AMBIENT_CRIMSON_FOREST_ADDITIONS, 0.0111));
        ModSounds.VAMPIRE_FOREST_AMBIENT.asOptional().map(arg_0 -> ((Registry)BuiltInRegistries.SOUND_EVENT).wrapAsHolder(arg_0)).ifPresent(soundEvent -> biomeSpecialEffectsBuilder.backgroundMusic(Musics.createGameMusic((Holder)soundEvent)));
        return VampirismBiomes.prepareVampireForestBuilder(featureGetter, carverGetter, mobSpawnBuilder, biomeSpecialEffectsBuilder).build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Biome.BiomeBuilder prepareVampireForestBuilder(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull MobSpawnSettings.Builder spawnBuilder, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BiomeSpecialEffects.Builder ambienceBuilder) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)builder);
        VampirismBiomes.addVampireFlower(builder);
        VampirismBiomes.addBushPatch(builder);
        BiomeDefaultFeatures.addForestGrass((BiomeGenerationSettings.Builder)builder);
        VampirismBiomes.addUndergroundVariety(builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)builder);
        VampirismBiomes.addVampireTrees(builder);
        VampirismBiomes.addWaterSprings(builder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.3f).downfall(0.0f).specialEffects(ambienceBuilder.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(builder.build());
    }

    public static void addVampireFlower(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VampirismFeatures.VAMPIRE_FLOWER_PLACED);
    }

    public static void addWaterSprings(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.FLUID_SPRINGS, MiscOverworldPlacements.SPRING_WATER);
    }

    public static void addVampireTrees(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VampirismFeatures.VAMPIRE_TREES_PLACED);
    }

    public static void addUndergroundVariety(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, OrePlacements.ORE_GRAVEL);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, VampirismFeatures.ORE_CURSED_DIRT_PLACED);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, VampirismFeatures.ORE_DARK_STONE_PLACED);
    }

    public static void addBushPatch(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VampirismFeatures.CURSED_ROOT_PLACED);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VampirismFeatures.FOREST_GRASS_PLACED);
    }

    public static void addDefaultCarversWithoutLakes(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BiomeGenerationSettings.Builder builder) {
        builder.addCarver(GenerationStep.Carving.AIR, Carvers.CAVE);
        builder.addCarver(GenerationStep.Carving.AIR, Carvers.CAVE_EXTRA_UNDERGROUND);
        builder.addCarver(GenerationStep.Carving.AIR, Carvers.CANYON);
    }
}

