/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVision;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVisionRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampireVisionRegistry
implements IVampireVisionRegistry {
    private static final String LEGACY_NAMESPACE = "vampirismlegacy";
    private final ArrayList<@NotNull IVampireVision> visionList = new ArrayList();
    private final BiMap<@NotNull ResourceLocation, @NotNull IVampireVision> visionMap = HashBiMap.create();

    @Override
    @NotNull
    public ResourceLocation getVisionId(IVampireVision vision) {
        ResourceLocation location = (ResourceLocation)this.visionMap.inverse().get((Object)vision);
        if (location == null) {
            throw new IllegalArgumentException("The given vision is not registered");
        }
        return location;
    }

    @Override
    @Nullable
    public IVampireVision getVision(ResourceLocation id) {
        return (IVampireVision)this.visionMap.get((Object)id);
    }

    @Override
    @NotNull
    public List<IVampireVision> getVisions() {
        return ImmutableList.copyOf(this.visionList);
    }

    @Override
    public <T extends IVampireVision> T registerVision(@NotNull ResourceLocation key, @NotNull T vision) {
        if (this.visionMap.containsKey((Object)key)) {
            throw new IllegalArgumentException("The given key is already registered");
        }
        this.visionList.add(vision);
        this.visionMap.put((Object)key, vision);
        return vision;
    }
}

