/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import de.teamlapen.vampirism.items.StakeItem;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.world.LevelFog;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Helper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean gettingSundamge(LivingEntity entity, LevelAccessor world, @Nullable ProfilerFiller profiler) {
        Level level;
        if (entity instanceof Player && entity.isSpectator()) {
            return false;
        }
        if (world instanceof Level && !(level = (Level)world).isRaining() && VampirismAPI.sundamageRegistry().hasSunDamage(world, entity.blockPosition()) && Helper.isDay(world)) {
            BlockPos pos = new BlockPos(entity.getBlockX(), entity.getBlockY() + (int)entity.getEyeHeight(), entity.getBlockZ());
            return Helper.canBlockSeeSun(world, pos) && !LevelFog.get(level).isInsideArtificialVampireFogArea(pos);
        }
        return false;
    }

    public static boolean isDay(LevelAccessor level) {
        float angle = level.getTimeOfDay(1.0f);
        return (double)angle > 0.78 || (double)angle < 0.24;
    }

    public static boolean canBlockSeeSun(@NotNull LevelAccessor world, @NotNull BlockPos pos) {
        if (pos.getY() >= world.getSeaLevel()) {
            return world.canSeeSky(pos);
        }
        BlockPos blockpos = new BlockPos(pos.getX(), world.getSeaLevel(), pos.getZ());
        if (!world.canSeeSky(blockpos)) {
            return false;
        }
        int liquidBlocks = 0;
        blockpos = blockpos.below();
        while (blockpos.getY() > pos.getY()) {
            BlockState state = world.getBlockState(blockpos);
            if (state.liquid()) {
                if (++liquidBlocks >= (Integer)VampirismConfig.BALANCE.vpSundamageWaterblocks.get()) {
                    return false;
                }
            } else {
                if (state.canOcclude() && (state.isFaceSturdy((BlockGetter)world, pos, Direction.DOWN) || state.isFaceSturdy((BlockGetter)world, pos, Direction.UP))) {
                    return false;
                }
                if (state.getLightBlock((BlockGetter)world, blockpos) > 0) {
                    return false;
                }
            }
            blockpos = blockpos.below();
        }
        return true;
    }

    @NotNull
    public static EnumStrength getGarlicStrength(@NotNull Entity e, LevelAccessor world) {
        return Helper.getGarlicStrengthAt(world, e.blockPosition());
    }

    @NotNull
    public static EnumStrength getGarlicStrengthAt(LevelAccessor world, @NotNull BlockPos pos) {
        return world instanceof Level ? VampirismAPI.garlicHandler((Level)world).getStrengthAtChunk(new ChunkPos(pos)) : EnumStrength.NONE;
    }

    @NotNull
    public static ResourceKey<Level> getWorldKey(LevelAccessor world) {
        return world instanceof Level ? ((Level)world).dimension() : (world instanceof ServerLevelAccessor ? ((ServerLevelAccessor)world).getLevel().dimension() : Level.OVERWORLD);
    }

    public static boolean canBecomeVampire(@NotNull Player player) {
        return FactionPlayerHandler.get(player).canJoin(VReference.VAMPIRE_FACTION);
    }

    public static boolean canTurnPlayer(IVampire biter, @Nullable Player target) {
        if (target != null && (target.isCreative() || target.isSpectator())) {
            return false;
        }
        if (biter instanceof IVampirePlayer) {
            IVampirePlayer player = (IVampirePlayer)biter;
            if (!((Boolean)VampirismConfig.SERVER.playerCanTurnPlayer.get()).booleanValue()) {
                return false;
            }
            return !(player instanceof ServerPlayer) || Permissions.INFECT_PLAYER.isAllowed((ServerPlayer)player);
        }
        return (Boolean)VampirismConfig.SERVER.disableMobBiteInfection.get() == false;
    }

    public static boolean isVampire(Entity entity) {
        return VReference.VAMPIRE_FACTION.equals(VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isHunter(Entity entity) {
        return VReference.HUNTER_FACTION.equals(VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isHunter(Player entity) {
        return VReference.HUNTER_FACTION.equals(VampirismPlayerAttributes.get((Player)entity).faction);
    }

    public static boolean isVampire(Player entity) {
        return VReference.VAMPIRE_FACTION.equals(VampirismPlayerAttributes.get((Player)entity).faction);
    }

    public static <T extends IFactionPlayer<T>> boolean areSkillsEnabled(@NotNull ISkillHandler<T> skillHandler, @NotNull List<ISkill<T>> skills) {
        for (ISkill<T> skill : skills) {
            if (skillHandler.isSkillEnabled(skill)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEntityInVampireBiome(@Nullable Entity e) {
        if (e == null) {
            return false;
        }
        Level w = e.getCommandSenderWorld();
        return w.getBiome(e.blockPosition()).is(ModTags.Biomes.IS_VAMPIRE_BIOME);
    }

    public static boolean isPosInVampireBiome(@NotNull BlockPos pos, @NotNull LevelAccessor level) {
        Holder biome = level.getBiome(pos);
        return biome.is(ModTags.Biomes.IS_VAMPIRE_BIOME);
    }

    public static boolean isEntityInArtificalVampireFogArea(@Nullable Entity e) {
        if (e == null) {
            return false;
        }
        Level w = e.getCommandSenderWorld();
        return LevelFog.getOpt(w).map(vh -> vh.isInsideArtificialVampireFogArea(e.blockPosition())).orElse(false);
    }

    public static ResourceLocation getBiomeId(@NotNull Entity e) {
        return Helper.getBiomeId((CommonLevelAccessor)e.getCommandSenderWorld(), e.blockPosition());
    }

    public static Holder<Biome> getBiome(@NotNull Entity e) {
        return e.getCommandSenderWorld().getBiome(e.blockPosition());
    }

    public static ResourceLocation getBiomeId(@NotNull CommonLevelAccessor world, @NotNull BlockPos pos) {
        return Helper.getBiomeId(world, (Holder<Biome>)world.getBiome(pos));
    }

    public static ResourceLocation getBiomeId(@NotNull CommonLevelAccessor world, @NotNull Holder<Biome> biome) {
        return (ResourceLocation)biome.unwrap().map(ResourceKey::location, b -> world.registryAccess().registryOrThrow(Registries.BIOME).getKey(b));
    }

    public static boolean canUseFactionItem(@NotNull ItemStack stack, @NotNull IFactionLevelItem<?> item, @NotNull IFactionPlayerHandler playerHandler) {
        IFaction<?> usingFaction = item.getExclusiveFaction(stack);
        ISkill<?> requiredSkill = item.getRequiredSkill(stack);
        int reqLevel = item.getMinLevel(stack);
        if (usingFaction != null && !playerHandler.isInFaction(usingFaction)) {
            return false;
        }
        if (playerHandler.getCurrentLevel() < reqLevel) {
            return false;
        }
        if (requiredSkill == null) {
            return true;
        }
        return playerHandler.getCurrentFactionPlayer().map(IFactionPlayer::getSkillHandler).map(s -> s.isSkillEnabled(requiredSkill)).orElse(false);
    }

    public static boolean attemptToGuessGenderSafe(Player p) {
        MinecraftProfileTextures textureMap;
        if (p instanceof ServerPlayer && (textureMap = ((ServerPlayer)p).server.getSessionService().getTextures(p.getGameProfile())).skin() != null) {
            return "slim".equals(textureMap.skin().getMetadata("model"));
        }
        return false;
    }

    @NotNull
    public static <T extends Entity> Optional<T> createEntity(@NotNull EntityType<T> type, @NotNull Level world) {
        Entity e = type.create(world);
        if (e == null) {
            LOGGER.warn("Failed to create entity of type {}", (Object)RegUtil.id(type));
            return Optional.empty();
        }
        return Optional.of(e);
    }

    @NotNull
    public static ListTag newDoubleNBTList(double ... numbers) {
        ListTag listnbt = new ListTag();
        for (double d0 : numbers) {
            listnbt.add((Object)DoubleTag.valueOf((double)d0));
        }
        return listnbt;
    }

    public static boolean canKillVampires(@NotNull DamageSource source) {
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && (source.is(ModTags.DamageTypes.VAMPIRE_IMMORTAL) || ((List)VampirismConfig.BALANCE.vpImmortalFromDamageSources.get()).contains(source.getMsgId()))) {
            if (source.getDirectEntity() instanceof LivingEntity) {
                return source.getDirectEntity() instanceof IHunterMob || ((LivingEntity)source.getDirectEntity()).getMainHandItem().getItem() instanceof StakeItem;
            }
            if (source.getDirectEntity() instanceof CrossbowArrowEntity) {
                return ((CrossbowArrowEntity)source.getDirectEntity()).getArrowType() == CrossbowArrowItem.EnumArrowType.VAMPIRE_KILLER;
            }
            return false;
        }
        return true;
    }

    public static boolean handleHeldNonVampireItem(ItemStack stack, Entity entity, boolean held) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (entity.tickCount % 16 == 8 && (held || living.getOffhandItem() == stack) && Helper.isVampire(entity)) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(ModEffects.POISON, 20, 1));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.getInventory().removeItem(stack);
                    player.drop(stack, true);
                }
                return true;
            }
        }
        return false;
    }
}

