/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DifficultyCalculator {
    @Nullable
    private static Difficulty calculateDifficulty(@Nullable List<? extends Player> playerList) {
        if (playerList == null || playerList.isEmpty()) {
            return null;
        }
        int min = Integer.MAX_VALUE;
        int max = 0;
        int sum = 0;
        int playerCount = 0;
        for (Player player : playerList) {
            if (!player.isAlive()) continue;
            ++playerCount;
            FactionPlayerHandler handler = FactionPlayerHandler.get(player);
            int pLevel = handler.getCurrentLevel();
            if (pLevel == 0) {
                min = 0;
                continue;
            }
            int level = Math.round((float)pLevel / (float)handler.getCurrentFaction().getHighestReachableLevel() * 100.0f);
            if (level < min) {
                min = level;
            }
            if (level > max) {
                max = level;
            }
            sum += max;
        }
        if (playerCount == 0) {
            return null;
        }
        return new Difficulty(min, max, Math.round((float)sum / (float)playerCount));
    }

    @Nullable
    public static Difficulty getWorldDifficulty(@NotNull Level w) {
        return DifficultyCalculator.calculateDifficulty(w.players());
    }

    @Nullable
    public static Difficulty getLocalDifficulty(@NotNull Level w, @NotNull BlockPos center, int radius) {
        List list = w.getEntitiesOfClass(Player.class, UtilLib.createBB(center, radius, true));
        return DifficultyCalculator.calculateDifficulty(list);
    }

    @Nullable
    public static Difficulty getGlobalDifficulty() {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            throw new IllegalStateException("You can only use this method on server side");
        }
        return DifficultyCalculator.calculateDifficulty(ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers());
    }

    @NotNull
    public static Difficulty findDifficultyForPos(@NotNull Level world, @NotNull BlockPos pos, int radius) {
        Difficulty d = DifficultyCalculator.getLocalDifficulty(world, pos, radius);
        if (d == null && (d = DifficultyCalculator.getWorldDifficulty(world)) == null && (d = DifficultyCalculator.getGlobalDifficulty()) == null) {
            d = new Difficulty(0, 0, 0);
        }
        return d;
    }
}

