/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.blocks.AlchemyTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.items.component.OilContent;
import de.teamlapen.vampirism.modcompat.jei.RecipeUtil;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import de.teamlapen.vampirism.recipes.AlchemyTableRecipe;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AlchemyTableRecipeCategory
implements IRecipeCategory<RecipeHolder<AlchemyTableRecipe>> {
    private static final ResourceLocation location = VResourceLocation.mod("textures/gui/container/alchemy_table.png");
    @NotNull
    private final Component localizedName = ((AlchemyTableBlock)((Object)ModBlocks.ALCHEMY_TABLE.get())).getName();
    @NotNull
    private final IDrawable icon;
    @NotNull
    private final IDrawable background;
    @NotNull
    private final IDrawableStatic blazeHeat;
    @NotNull
    private final IDrawableAnimated arrow;
    @NotNull
    private final IDrawableAnimated pool;

    public AlchemyTableRecipeCategory(@NotNull IGuiHelper helper) {
        this.background = helper.drawableBuilder(location, 11, 12, 149, 80).addPadding(0, 30, 0, 0).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.ALCHEMY_TABLE.get()));
        this.blazeHeat = helper.createDrawable(location, 176, 9, 18, 4);
        this.arrow = helper.drawableBuilder(location, 176, 1, 28, 8).buildAnimated(600, IDrawableAnimated.StartDirection.LEFT, false);
        this.pool = helper.drawableBuilder(location, 176, 13, 32, 32).buildAnimated(600, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @NotNull
    public RecipeType<RecipeHolder<AlchemyTableRecipe>> getRecipeType() {
        return VampirismJEIPlugin.ALCHEMY_TABLE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull RecipeHolder<AlchemyTableRecipe> holder, @NotNull IFocusGroup focuses) {
        AlchemyTableRecipe recipe = (AlchemyTableRecipe)holder.value();
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 13).addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 4).addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.INPUT, 68, 4).addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 101, 60).addItemStack(RecipeUtil.getResultItem(recipe));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 129, 32).addItemStack(RecipeUtil.getResultItem(recipe));
        builder.addSlot(RecipeIngredientRole.INPUT, 23, 57).addItemStack(new ItemStack((ItemLike)Items.BLAZE_POWDER));
    }

    public void draw(@NotNull RecipeHolder<AlchemyTableRecipe> holder, IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        AlchemyTableRecipe recipe = (AlchemyTableRecipe)holder.value();
        this.blazeHeat.draw(graphics, 22, 48);
        this.arrow.draw(graphics, 62, 45);
        int color = ((IOil)OilContent.getOil(RecipeUtil.getResultItem(recipe)).value()).getColor();
        graphics.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f);
        this.pool.draw(graphics, 93, 24);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int x = 2;
        int y = 80;
        Minecraft minecraft = Minecraft.getInstance();
        List<ISkill<?>> requiredSkills = recipe.getRequiredSkills();
        if (!requiredSkills.isEmpty()) {
            MutableComponent skillText = Component.translatable((String)"gui.vampirism.skill_required", (Object[])new Object[]{" "});
            for (ISkill<?> skill : recipe.getRequiredSkills()) {
                skillText.append((Component)skill.getName()).append(" ");
            }
            y += UtilLib.renderMultiLine(minecraft.font, graphics, (Component)skillText, 132, x, y, Color.gray.getRGB());
        }
    }
}

