/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.recipes;

import de.maxanier.guideapi.api.IRecipeRenderer;
import de.maxanier.guideapi.api.SubTexture;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.api.util.IngredientCycler;
import de.maxanier.guideapi.gui.BaseScreen;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BasicWeaponTableRecipeRenderer<T extends IWeaponTableRecipe>
extends IRecipeRenderer.RecipeRendererBase<T> {
    private final SubTexture CRAFTING_GRID = new SubTexture(ResourceLocation.fromNamespaceAndPath((String)"vampirismguide", (String)"textures/gui/weapon_table_recipe.png"), 0, 0, 110, 75);

    public BasicWeaponTableRecipeRenderer(T recipe) {
        super(recipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(@NotNull GuiGraphics guiGraphics, RegistryAccess registryAccess, Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, int guiLeft, int guiTop, int mouseX, int mouseY, @NotNull BaseScreen baseScreen, @NotNull Font fontRenderer, IngredientCycler ingredientCycler) {
        this.CRAFTING_GRID.draw(guiGraphics, guiLeft + 62, guiTop + 43);
        baseScreen.drawCenteredStringWithoutShadow(guiGraphics, fontRenderer, (Component)((WeaponTableBlock)((Object)ModBlocks.WEAPON_TABLE.get())).getName(), guiLeft + baseScreen.xSize / 2, guiTop + 12, 0);
        MutableComponent mutableComponent = this.getRecipeName().withStyle(style -> style.withItalic(Boolean.valueOf(true)));
        int n = guiLeft + baseScreen.xSize / 2;
        Objects.requireNonNull(fontRenderer);
        baseScreen.drawCenteredStringWithoutShadow(guiGraphics, fontRenderer, (Component)mutableComponent, n, guiTop + 14 + 9, 0);
        int outputX = guiLeft + 152;
        int outputY = guiTop + 72;
        ItemStack itemStack = ((IWeaponTableRecipe)this.recipe).getResultItem((HolderLookup.Provider)registryAccess);
        GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)itemStack, (int)outputX, (int)outputY);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)outputX, (int)outputY, (int)15, (int)15)) {
            this.tooltips = GuiHelper.getTooltip((ItemStack)((IWeaponTableRecipe)this.recipe).getResultItem((HolderLookup.Provider)registryAccess));
        }
        if (((IWeaponTableRecipe)this.recipe).getRequiredLavaUnits() > 0) {
            GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)new ItemStack((ItemLike)Items.LAVA_BUCKET), (int)(outputX - 16), (int)(outputY + 21));
        }
        int y = guiTop + 120;
        if (((IWeaponTableRecipe)this.recipe).getRequiredLevel() > 1) {
            MutableComponent level = Component.translatable((String)"gui.vampirism.hunter_weapon_table.level", (Object[])new Object[]{((IWeaponTableRecipe)this.recipe).getRequiredLevel()});
            guiGraphics.drawString(fontRenderer, (Component)level, guiLeft + 40, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(fontRenderer);
            y += 9 + 2;
        }
        if (!((IWeaponTableRecipe)this.recipe).getRequiredSkills().isEmpty()) {
            MutableComponent newLine = Component.literal((String)"\n");
            ArrayList<MutableComponent> skills = new ArrayList<MutableComponent>();
            skills.add(Component.translatable((String)"gui.vampirism.skill_required", (Object[])new Object[]{"\n"}));
            for (ISkill<IHunterPlayer> skill : ((IWeaponTableRecipe)this.recipe).getRequiredSkills()) {
                skills.add(skill.getName().copy().withStyle(ChatFormatting.ITALIC));
                skills.add(newLine);
            }
            guiGraphics.drawWordWrap(fontRenderer, FormattedText.composite(skills), guiLeft + 40, y, 110, Color.GRAY.getRGB());
        }
    }

    protected MutableComponent getRecipeName() {
        return Component.translatable((String)"guideapi.text.crafting.shaped");
    }
}

