/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items.crossbow;

import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IArrowContainer;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.items.crossbow.VampirismCrossbowItem;
import de.teamlapen.vampirism.util.ModEnchantmentHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class TechCrossbowItem
extends VampirismCrossbowItem {
    public TechCrossbowItem(Item.Properties properties, float arrowVelocity, int chargeTime, Tier itemTier) {
        super(properties, arrowVelocity, chargeTime, itemTier);
    }

    @Override
    @Nullable
    public ISkill<IHunterPlayer> getRequiredSkill(@Nonnull ItemStack stack) {
        return (ISkill)HunterSkills.TECH_WEAPONS.get();
    }

    @Override
    @Nonnull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> stack.getItem() instanceof IArrowContainer && !((IArrowContainer)stack.getItem()).getArrows((ItemStack)stack).isEmpty();
    }

    @Override
    protected void onShoot(LivingEntity shooter, ItemStack crossbow) {
        super.onShoot(shooter, crossbow);
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            player.getCooldowns().addCooldown((Item)this, 10);
        }
    }

    @Override
    protected List<ItemStack> getShootingProjectiles(ServerLevel serverLevel, ItemStack crossbow, List<ItemStack> availableProjectiles) {
        if (!ModEnchantmentHelper.processFrugality(serverLevel, crossbow)) {
            return List.of(availableProjectiles.removeFirst());
        }
        crossbow.set(ModDataComponents.CROSSBOW_FRUGALITY_TRIGGERED, (Object)Unit.INSTANCE);
        return List.of(availableProjectiles.getFirst());
    }

    @Override
    public boolean isValidRepairItem(@Nonnull ItemStack crossbow, ItemStack repairItem) {
        return repairItem.is(Tags.Items.INGOTS_IRON);
    }

    @Override
    public int getChargeDurationMod(ItemStack crossbow, Level level) {
        return this.chargeTime;
    }

    @Override
    public boolean canSelectAmmunition(ItemStack crossbow) {
        return false;
    }

    @Override
    public Optional<Item> getAmmunition(ItemStack crossbow) {
        return Optional.empty();
    }

    public boolean isPrimaryItemFor(@NotNull ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(ModTags.Enchantments.TECH_CROSSBOW) || super.isPrimaryItemFor(stack, enchantment);
    }
}

