/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.HunterTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModMenus;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.items.PureBloodItem;
import de.teamlapen.vampirism.mixin.accessor.ItemCombinerMenuAccessor;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;

public class HunterTableMenu
extends ItemCombinerMenu {
    private final Optional<HunterLeveling.HunterTableRequirement> tableRequirement;

    public HunterTableMenu(int id, @NotNull Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super((MenuType)ModMenus.HUNTER_TABLE.get(), id, playerInventory, worldPosCallable);
        int hunterLevel = FactionPlayerHandler.get(playerInventory.player).getCurrentLevel(VReference.HUNTER_FACTION);
        this.tableRequirement = HunterLeveling.getTrainerRequirement(hunterLevel + 1).map(HunterLeveling.HunterTrainerRequirement::tableRequirement);
    }

    public Optional<HunterLeveling.HunterTableRequirement> getTableRequirement() {
        return this.tableRequirement.filter(this::doesTableFulfillRequirement);
    }

    public Optional<HunterLeveling.HunterTableRequirement> getRequirement() {
        return this.tableRequirement;
    }

    @NotNull
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 15, 28, stack -> stack.is(Items.BOOK)).withSlot(1, 42, 28, stack -> stack.is((Item)ModItems.VAMPIRE_FANG.get())).withSlot(2, 69, 28, stack -> this.tableRequirement.filter(req -> {
            int n;
            int n2 = req.pureBloodLevel();
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof PureBloodItem) {
                PureBloodItem pure = (PureBloodItem)patt0$temp;
                n = pure.getLevel();
            } else {
                n = -1;
            }
            return n2 <= n;
        }).isPresent()).withSlot(3, 96, 28, stack -> stack.is((Item)ModItems.VAMPIRE_BOOK.get())).withResultSlot(4, 146, 28).build();
    }

    protected boolean mayPickup(@NotNull Player pPlayer, boolean pHasStack) {
        return true;
    }

    protected void onTake(@NotNull Player player, @NotNull ItemStack stack) {
        this.tableRequirement.ifPresent(req -> InventoryHelper.removeItems(this.getInputSlots(), req.bookQuantity(), req.vampireFangQuantity(), req.pureBloodQuantity(), req.vampireBookQuantity()));
    }

    protected boolean isValidBlock(@NotNull BlockState pState) {
        return pState.is((Block)ModBlocks.HUNTER_TABLE.get());
    }

    public void createResult() {
        this.tableRequirement.filter(this::isRequirementFulfilled).map(s -> s.resultIntelItem().get()).ifPresentOrElse(intel -> this.resultSlots.setItem(0, intel.getDefaultInstance()), () -> this.resultSlots.setItem(0, ItemStack.EMPTY));
    }

    private boolean isRequirementFulfilled(HunterLeveling.HunterTableRequirement req) {
        return this.getInputSlots().countItem(Items.BOOK) >= 1 && this.getInputSlots().countItem((Item)ModItems.VAMPIRE_FANG.get()) >= req.vampireFangQuantity() && this.countPureBlood(req) >= req.pureBloodQuantity() && this.getInputSlots().countItem((Item)ModItems.VAMPIRE_BOOK.get()) >= req.vampireBookQuantity();
    }

    private Container getInputSlots() {
        return ((ItemCombinerMenuAccessor)((Object)this)).getInputSlots();
    }

    private int countPureBlood(HunterLeveling.HunterTableRequirement req) {
        return IntStream.range(req.pureBloodLevel(), 5).mapToObj(PureBloodItem::getBloodItemForLevel).mapToInt(arg_0 -> ((Container)this.getInputSlots()).countItem(arg_0)).sum();
    }

    public boolean doesTableFulfillRequirement(HunterLeveling.HunterTableRequirement req) {
        return req.requiredTableTier() <= (Integer)this.access.evaluate((level, pos) -> {
            BlockState state = level.getBlockState(pos);
            return state.hasProperty(HunterTableBlock.VARIANT) ? ((HunterTableBlock.TABLE_VARIANT)((Object)((Object)state.getValue(HunterTableBlock.VARIANT)))).tier : 0;
        }, (Object)0);
    }

    public static class Factory
    implements IContainerFactory<HunterTableMenu> {
        @NotNull
        public HunterTableMenu create(int windowId, @NotNull Inventory inv, @NotNull RegistryFriendlyByteBuf data) {
            BlockPos pos = data.readBlockPos();
            return new HunterTableMenu(windowId, inv, ContainerLevelAccess.create((Level)inv.player.level(), (BlockPos)pos));
        }
    }
}

