/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryContainerMenu;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModMenus;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterBasicMenu
extends InventoryContainerMenu {
    private static final InventoryContainerMenu.SelectorInfo[] SELECTOR_INFOS = new InventoryContainerMenu.SelectorInfo[]{new InventoryContainerMenu.SelectorInfo((Item)ModItems.VAMPIRE_BLOOD_BOTTLE.get(), 27, 32)};
    @NotNull
    private final IHunterPlayer player;
    @Nullable
    private final BasicHunterEntity entity;

    @Deprecated
    public HunterBasicMenu(int id, @NotNull Inventory playerInventory) {
        this(id, playerInventory, null);
    }

    public HunterBasicMenu(int id, @NotNull Inventory playerInventory, @Nullable BasicHunterEntity hunter) {
        super((MenuType<? extends InventoryContainerMenu>)((MenuType)ModMenus.HUNTER_BASIC.get()), id, playerInventory, hunter == null ? ContainerLevelAccess.NULL : ContainerLevelAccess.create((Level)hunter.level(), (BlockPos)hunter.blockPosition()), (Container)new SimpleContainer(SELECTOR_INFOS.length), SELECTOR_INFOS);
        this.player = HunterPlayer.get(playerInventory.player);
        this.addPlayerSlots(playerInventory);
        this.entity = hunter;
    }

    public int getMissingCount() {
        int targetLevel = this.player.getLevel() + 1;
        ItemStack blood = this.inventory.getItem(0);
        return HunterLeveling.getBasicHunterRequirement(targetLevel).map(req -> {
            int required = req.vampireBloodAmount();
            return blood.isEmpty() || !blood.getItem().equals(ModItems.VAMPIRE_BLOOD_BOTTLE.get()) ? required : Math.max(0, required - blood.getCount());
        }).orElse(-1);
    }

    public boolean canLevelUp() {
        return this.getMissingCount() == 0;
    }

    public void onLevelUpClicked() {
        if (!this.canLevelUp()) {
            return;
        }
        int target = this.player.getLevel() + 1;
        HunterLeveling.getBasicHunterRequirement(target).ifPresent(req -> {
            this.inventory.removeItem(0, req.vampireBloodAmount());
            Player player1 = this.player.asEntity();
            FactionPlayerHandler.get(player1).setFactionLevel(VReference.HUNTER_FACTION, target);
            player1.displayClientMessage((Component)Component.translatable((String)"container.vampirism.basic_hunter.levelup"), false);
            player1.closeContainer();
        });
    }

    @Override
    public void removed(@NotNull Player playerIn) {
        super.removed(playerIn);
        if (!playerIn.getCommandSenderWorld().isClientSide) {
            this.clearContainer(playerIn, this.inventory);
        }
    }

    @Override
    public boolean stillValid(@NotNull Player playerIn) {
        if (this.entity == null) {
            return false;
        }
        return new Vec3(playerIn.getX(), playerIn.getY(), playerIn.getZ()).distanceTo(new Vec3(this.entity.getX(), this.entity.getY(), this.entity.getZ())) < 5.0;
    }
}

