/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire.action;

import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.vampire.action.VampireEntityAction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class SunscreenEntityAction<T extends PathfinderMob>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public SunscreenEntityAction(@NotNull EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public void activate(@NotNull T entity) {
        ((IFactionEntity)entity).asEntity().addEffect(new MobEffectInstance(ModEffects.SUNSCREEN, this.getDuration(((IAdjustableLevel)entity).getEntityLevel()), 3, false, false));
    }

    @Override
    public void deactivate(@NotNull T entity) {
        ((IFactionEntity)entity).asEntity().removeEffect(ModEffects.SUNSCREEN);
    }

    @Override
    public int getCooldown(int level) {
        return (Integer)VampirismConfig.BALANCE.eaSunscreenCooldown.get() * 20;
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.eaSunscreenDuration.get() * 20;
    }

    @Override
    public int getWeight(@NotNull PathfinderMob entity) {
        if (!entity.getCommandSenderWorld().isDay() || entity.getCommandSenderWorld().isRaining()) {
            return 0;
        }
        return ((IVampire)entity).isGettingSundamage((LevelAccessor)entity.getCommandSenderWorld()) ? 3 : 1;
    }

    @Override
    public void onUpdate(T entity, int duration) {
    }
}

