/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire.action;

import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.vampire.action.VampireEntityAction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.NotNull;

public class RegenerationEntityAction<T extends PathfinderMob>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public RegenerationEntityAction(@NotNull EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public void activate(T entity) {
    }

    @Override
    public void deactivate(T entity) {
    }

    @Override
    public int getCooldown(int level) {
        return (Integer)VampirismConfig.BALANCE.eaRegenerationCooldown.get() * 20;
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.eaRegenerationDuration.get() * 20;
    }

    @Override
    public int getWeight(@NotNull PathfinderMob entity) {
        double healthPercent = entity.getHealth() / entity.getMaxHealth();
        if (healthPercent < 0.1) {
            return 3;
        }
        if (healthPercent < 0.4) {
            return 2;
        }
        return 1;
    }

    @Override
    public void onUpdate(@NotNull T entity, int duration) {
        ((IFactionEntity)entity).asEntity().heal(entity.getMaxHealth() / 100.0f * (float)((Integer)VampirismConfig.BALANCE.eaRegenerationAmount.get()).intValue() / ((float)this.getDuration(((IAdjustableLevel)entity).getEntityLevel()) * 20.0f));
        if (duration % 15 == 0) {
            ModParticles.spawnParticlesServer(entity.getCommandSenderWorld(), (ParticleOptions)ParticleTypes.HEART, entity.getX(), entity.getY() + 1.0, entity.getZ(), 3, 0.2, 0.2, 0.2, 0.0);
        }
    }
}

