/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire.skills;

import de.teamlapen.vampirism.advancements.critereon.PlayerFactionSubPredicate;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.ISkillNode;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.lord.skills.LordSkills;
import de.teamlapen.vampirism.entity.player.skills.ActionSkill;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.entity.player.skills.SkillTree;
import de.teamlapen.vampirism.entity.player.skills.VampirismSkill;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import java.util.Collection;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class VampireSkills {
    public static final DeferredRegister<ISkill<?>> SKILLS = DeferredRegister.create(VampirismRegistries.Keys.SKILL, (String)"vampirism");
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> LEVEL_ROOT = SKILLS.register(VReference.VAMPIRE_FACTION.getID().getPath(), () -> new VampirismSkill.SimpleVampireSkill(0, false));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> LORD_ROOT = SKILLS.register(VReference.VAMPIRE_FACTION.getID().withSuffix("_lord").getPath(), () -> new VampirismSkill.SimpleVampireSkill(0, false));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ADVANCED_BITER = SKILLS.register("advanced_biter", () -> new VampirismSkill.SimpleVampireSkill(1, false).setToggleActions(player -> {
        ((VampirePlayer)player).getSpecialAttributes().advanced_biter = true;
    }, player -> {
        ((VampirePlayer)player).getSpecialAttributes().advanced_biter = false;
    }).setHasDefaultDescription());
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> FLEDGLING = SKILLS.register("fledgling", () -> new VampirismSkill.SimpleVampireSkill(2, true){

        @Override
        protected void getActions(@NotNull Collection<IAction<IVampirePlayer>> list) {
            list.add((IAction)VampireActions.BAT.get());
            list.add((IAction)VampireActions.INFECT.get());
        }
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOOD_CHARGE = SKILLS.register("blood_charge", () -> new VampirismSkill.SimpleVampireSkill(1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOOD_VISION = SKILLS.register("blood_vision", () -> new VampirismSkill.SimpleVampireSkill(2, true).setToggleActions(player -> player.unlockVision(VReference.vision_bloodVision), player -> player.unUnlockVision(VReference.vision_bloodVision)));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOOD_VISION_GARLIC = SKILLS.register("blood_vision_garlic", () -> new VampirismSkill.SimpleVampireSkill(1, true).setToggleActions(player -> {
        ((VampirePlayer)player).getSpecialAttributes().blood_vision_garlic = true;
    }, player -> {
        ((VampirePlayer)player).getSpecialAttributes().blood_vision_garlic = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> DARK_BLOOD_PROJECTILE = SKILLS.register("dark_blood_projectile", () -> new ActionSkill(VampireActions.DARK_BLOOD_PROJECTILE, Trees.LEVEL, 2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> FREEZE = SKILLS.register("freeze", () -> new ActionSkill(VampireActions.FREEZE, Trees.LEVEL, 2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> HALF_INVULNERABLE = SKILLS.register("half_invulnerable", () -> new ActionSkill(VampireActions.HALF_INVULNERABLE, Trees.LEVEL, 2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> LESS_BLOOD_THIRST = SKILLS.register("less_blood_thirst", () -> new VampirismSkill.SimpleVampireSkill(1, true).registerAttributeModifier((Holder<Attribute>)ModAttributes.BLOOD_EXHAUSTION, () -> (Double)VampirismConfig.BALANCE.vsBloodThirstReduction1.get(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> LESS_SUNDAMAGE = SKILLS.register("less_sundamage", () -> new VampirismSkill.SimpleVampireSkill(3, true).registerAttributeModifier((Holder<Attribute>)ModAttributes.SUNDAMAGE, () -> (Double)VampirismConfig.BALANCE.vsSundamageReduction1.get(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NIGHT_VISION = SKILLS.register("night_vision", () -> new VampirismSkill.SimpleVampireSkill(2, false).setToggleActions(player -> {
        player.unlockVision(VReference.vision_nightVision);
        player.activateVision(VReference.vision_nightVision);
    }, player -> player.unUnlockVision(VReference.vision_nightVision)));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> SUNSCREEN = SKILLS.register("sunscreen", () -> new ActionSkill(VampireActions.SUNSCREEN, Trees.LEVEL, 2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> SUMMON_BATS = SKILLS.register("summon_bats", () -> new ActionSkill(VampireActions.SUMMON_BAT, Trees.LEVEL, 2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> SWORD_FINISHER = SKILLS.register("sword_finisher", () -> new VampirismSkill.SimpleVampireSkill(2, true).setDescription(() -> Component.translatable((String)"skill.vampirism.sword_finisher.desc", (Object[])new Object[]{(int)((Double)VampirismConfig.BALANCE.vsSwordFinisherMaxHealth.get() * 100.0)})));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> TELEPORT = SKILLS.register("teleport", () -> new ActionSkill(VampireActions.TELEPORT, Trees.LEVEL, 3, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> VAMPIRE_DISGUISE = SKILLS.register("vampire_disguise", () -> new ActionSkill(VampireActions.DISGUISE_VAMPIRE, Trees.LEVEL, 1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> VAMPIRE_INVISIBILITY = SKILLS.register("vampire_invisibility", () -> new ActionSkill(VampireActions.VAMPIRE_INVISIBILITY, Trees.LEVEL, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> VAMPIRE_JUMP = SKILLS.register("vampire_jump", () -> new ActionSkill(VampireActions.JUMP_BOOST, Trees.LEVEL, 2, false));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> VAMPIRE_RAGE = SKILLS.register("vampire_rage", () -> new ActionSkill(VampireActions.VAMPIRE_RAGE, Trees.LEVEL, 2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> VAMPIRE_REGENERATION = SKILLS.register("vampire_regeneration", () -> new ActionSkill(VampireActions.REGEN, Trees.LEVEL, 2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> VAMPIRE_SPEED = SKILLS.register("vampire_speed", () -> new VampirismSkill.SimpleVampireSkill(2, false).registerAttributeModifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, () -> (Double)VampirismConfig.BALANCE.vsSpeedBoost.get(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> WATER_RESISTANCE = SKILLS.register("water_resistance", () -> new VampirismSkill.SimpleVampireSkill(2, true).setToggleActions(player -> {
        ((VampirePlayer)player).getSpecialAttributes().waterResistance = true;
    }, player -> {
        ((VampirePlayer)player).getSpecialAttributes().waterResistance = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> VAMPIRE_ATTACK_SPEED = SKILLS.register("vampire_attack_speed", () -> new VampirismSkill.SimpleVampireSkill(2, false).registerAttributeModifier((Holder<Attribute>)Attributes.ATTACK_SPEED, () -> (Double)VampirismConfig.BALANCE.vsSmallAttackSpeedModifier.get(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> VAMPIRE_ATTACK_DAMAGE = SKILLS.register("vampire_attack_damage", () -> new VampirismSkill.SimpleVampireSkill(2, false).registerAttributeModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, () -> (Double)VampirismConfig.BALANCE.vsSmallAttackDamageModifier.get(), AttributeModifier.Operation.ADD_VALUE).registerAttributeModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, () -> (Double)VampirismConfig.BALANCE.vsSmallAttackDamageMultiplier.get(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NEONATAL_DECREASE = SKILLS.register("neonatal_decrease", () -> new VampirismSkill.SimpleVampireSkill(2, true).registerAttributeModifier((Holder<Attribute>)ModAttributes.NEONATAL_DURATION, () -> (Double)VampirismConfig.BALANCE.vsNeonatalReduction.get() - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> DBNO_DURATION = SKILLS.register("dbno_duration", () -> new VampirismSkill.SimpleVampireSkill(2, true).registerAttributeModifier((Holder<Attribute>)ModAttributes.DBNO_DURATION, () -> (Double)VampirismConfig.BALANCE.vsDbnoReduction.get() - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> HISSING = SKILLS.register("hissing", () -> new ActionSkill(VampireActions.HISSING, Trees.LEVEL, 1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> MINION_COLLECT = SKILLS.register("vampire_minion_collect", () -> new VampirismSkill.VampireLordSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> MINION_STATS_INCREASE = SKILLS.register("vampire_minion_stats_increase", () -> new VampirismSkill.VampireLordSkill(3, true).setToggleActions(vampire -> vampire.updateMinionAttributes(true), vampire -> vampire.updateMinionAttributes(false)));

    @ApiStatus.Internal
    public static void register(IEventBus bus) {
        SKILLS.register(bus);
    }

    public static class Trees {
        public static final ResourceKey<ISkillTree> LEVEL = Trees.tree("level");
        public static final ResourceKey<ISkillTree> LORD = Trees.tree("lord");

        private static ResourceKey<ISkillTree> tree(String path) {
            return ResourceKey.create(VampirismRegistries.Keys.SKILL_TREE, (ResourceLocation)VResourceLocation.mod("vampire/" + path));
        }

        public static void createSkillTrees(BootstrapContext<ISkillTree> context) {
            HolderGetter lookup = context.lookup(VampirismRegistries.Keys.SKILL_NODE);
            context.register(LEVEL, (Object)new SkillTree(VReference.VAMPIRE_FACTION, EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)PlayerFactionSubPredicate.faction(VReference.VAMPIRE_FACTION)).build(), new ItemStack((ItemLike)ModItems.VAMPIRE_BOOK.get()), (Component)Component.translatable((String)"text.vampirism.skills.level")));
            context.register(LORD, (Object)new SkillTree(VReference.VAMPIRE_FACTION, EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)PlayerFactionSubPredicate.lord(VReference.VAMPIRE_FACTION)).build(), new ItemStack((ItemLike)ModItems.VAMPIRE_MINION_BINDING.get()), (Component)Component.translatable((String)"text.vampirism.skills.lord")));
        }
    }

    public static class Nodes {
        public static final ResourceKey<ISkillNode> LEVEL_ROOT = Nodes.node("level_root");
        public static final ResourceKey<ISkillNode> SKILL2 = Nodes.node("skill2");
        public static final ResourceKey<ISkillNode> SKILL3 = Nodes.node("skill3");
        public static final ResourceKey<ISkillNode> SKILL4 = Nodes.node("skill4");
        public static final ResourceKey<ISkillNode> DEFENSIVE1 = Nodes.node("defensive1");
        public static final ResourceKey<ISkillNode> DEFENSIVE2 = Nodes.node("defensive2");
        public static final ResourceKey<ISkillNode> DEFENSIVE3 = Nodes.node("defensive3");
        public static final ResourceKey<ISkillNode> DEFENSIVE4 = Nodes.node("defensive4");
        public static final ResourceKey<ISkillNode> DEFENSIVE5 = Nodes.node("defensive5");
        public static final ResourceKey<ISkillNode> DEFENSIVE6 = Nodes.node("defensive6");
        public static final ResourceKey<ISkillNode> DEFENSIVE7 = Nodes.node("defensive7");
        public static final ResourceKey<ISkillNode> OFFENSIVE1 = Nodes.node("offensive1");
        public static final ResourceKey<ISkillNode> OFFENSIVE2 = Nodes.node("offensive2");
        public static final ResourceKey<ISkillNode> OFFENSIVE3 = Nodes.node("offensive3");
        public static final ResourceKey<ISkillNode> OFFENSIVE4 = Nodes.node("offensive4");
        public static final ResourceKey<ISkillNode> OFFENSIVE5 = Nodes.node("offensive5");
        public static final ResourceKey<ISkillNode> OFFENSIVE6 = Nodes.node("offensive6");
        public static final ResourceKey<ISkillNode> UTIL1 = Nodes.node("util1");
        public static final ResourceKey<ISkillNode> UTIL2 = Nodes.node("util2");
        public static final ResourceKey<ISkillNode> UTIL3 = Nodes.node("util3");
        public static final ResourceKey<ISkillNode> UTIL4 = Nodes.node("util4");
        public static final ResourceKey<ISkillNode> UTIL5 = Nodes.node("util5");
        public static final ResourceKey<ISkillNode> UTIL6 = Nodes.node("util6");
        public static final ResourceKey<ISkillNode> UTIL15 = Nodes.node("util15");
        public static final ResourceKey<ISkillNode> LORD_ROOT = Nodes.node("lord_root");
        public static final ResourceKey<ISkillNode> LORD_SKILL2 = Nodes.node("lord_skill2");
        public static final ResourceKey<ISkillNode> LORD_SKILL3 = Nodes.node("lord_skill3");
        public static final ResourceKey<ISkillNode> LORD_SKILL4 = Nodes.node("lord_skill4");
        public static final ResourceKey<ISkillNode> LORD_SKILL5 = Nodes.node("lord_skill5");

        private static ResourceKey<ISkillNode> node(String path) {
            return ResourceKey.create(VampirismRegistries.Keys.SKILL_NODE, (ResourceLocation)VResourceLocation.mod("vampire/" + path));
        }

        public static void createSkillNodes(BootstrapContext<ISkillNode> context) {
            context.register(LEVEL_ROOT, (Object)new SkillNode(new Holder[]{LEVEL_ROOT}));
            context.register(SKILL2, (Object)new SkillNode(new Holder[]{NIGHT_VISION}));
            context.register(SKILL3, (Object)new SkillNode(new Holder[]{VAMPIRE_REGENERATION}));
            context.register(SKILL4, (Object)new SkillNode(new Holder[]{FLEDGLING}));
            context.register(DEFENSIVE1, (Object)new SkillNode(new Holder[]{SUNSCREEN}));
            context.register(DEFENSIVE2, (Object)new SkillNode(new Holder[]{VAMPIRE_ATTACK_SPEED, VAMPIRE_SPEED}));
            context.register(DEFENSIVE3, (Object)new SkillNode(new Holder[]{BLOOD_VISION}));
            context.register(DEFENSIVE4, (Object)new SkillNode(new Holder[]{BLOOD_VISION_GARLIC}));
            context.register(DEFENSIVE5, (Object)new SkillNode(new Holder[]{VAMPIRE_ATTACK_DAMAGE, VAMPIRE_JUMP}));
            context.register(DEFENSIVE6, (Object)new SkillNode(new Holder[]{NEONATAL_DECREASE, DBNO_DURATION}));
            context.register(DEFENSIVE7, (Object)new SkillNode(new Holder[]{TELEPORT}));
            context.register(OFFENSIVE1, (Object)new SkillNode(new Holder[]{VAMPIRE_RAGE}));
            context.register(OFFENSIVE2, (Object)new SkillNode(new Holder[]{ADVANCED_BITER}));
            context.register(OFFENSIVE3, (Object)new SkillNode(new Holder[]{SWORD_FINISHER}));
            context.register(OFFENSIVE4, (Object)new SkillNode(new Holder[]{DARK_BLOOD_PROJECTILE}));
            context.register(OFFENSIVE5, (Object)new SkillNode(new Holder[]{BLOOD_CHARGE}));
            context.register(OFFENSIVE6, (Object)new SkillNode(new Holder[]{FREEZE}));
            context.register(UTIL1, (Object)new SkillNode(new Holder[]{SUMMON_BATS}));
            context.register(UTIL2, (Object)new SkillNode(new Holder[]{LESS_SUNDAMAGE, WATER_RESISTANCE}));
            context.register(UTIL3, (Object)new SkillNode(new Holder[]{LESS_BLOOD_THIRST}));
            context.register(UTIL4, (Object)new SkillNode(new Holder[]{VAMPIRE_DISGUISE}));
            context.register(UTIL5, (Object)new SkillNode(new Holder[]{HALF_INVULNERABLE}));
            context.register(UTIL6, (Object)new SkillNode(new Holder[]{VAMPIRE_INVISIBILITY}));
            context.register(UTIL15, (Object)new SkillNode(new Holder[]{HISSING}));
            context.register(LORD_ROOT, (Object)new SkillNode(new Holder[]{LORD_ROOT}));
            context.register(LORD_SKILL2, (Object)new SkillNode(new Holder[]{MINION_STATS_INCREASE}));
            context.register(LORD_SKILL3, (Object)new SkillNode(new Holder[]{LordSkills.LORD_SPEED, LordSkills.LORD_ATTACK_SPEED}));
            context.register(LORD_SKILL4, (Object)new SkillNode(new Holder[]{MINION_COLLECT}));
            context.register(LORD_SKILL5, (Object)new SkillNode(new Holder[]{LordSkills.MINION_RECOVERY}));
        }
    }
}

