/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire.actions;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.BlindingBatEntity;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SummonBatVampireAction
extends DefaultVampireAction {
    @Override
    public boolean activate(@NotNull IVampirePlayer player, IAction.ActivationContext context) {
        Player entityPlayer = player.asEntity();
        boolean refined = player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.SUMMON_BATS.get());
        int amount = (Integer)VampirismConfig.BALANCE.vaSummonBatsCount.get();
        if (amount > 1 && refined) {
            amount /= 2;
        }
        for (int i = 0; i < amount; ++i) {
            BlindingBatEntity e = (BlindingBatEntity)((EntityType)ModEntities.BLINDING_BAT.get()).create(entityPlayer.getCommandSenderWorld());
            e.restrictLiveSpan();
            if (refined) {
                e.setTargeting();
            }
            e.setResting(false);
            e.copyPosition((Entity)player.asEntity());
            player.asEntity().getCommandSenderWorld().addFreshEntity((Entity)e);
        }
        entityPlayer.getCommandSenderWorld().playSound(null, entityPlayer.getX(), entityPlayer.getY(), entityPlayer.getZ(), (SoundEvent)ModSounds.BAT_SWARM.get(), SoundSource.PLAYERS, 1.3f, entityPlayer.getCommandSenderWorld().random.nextFloat() * 0.2f + 1.3f);
        return true;
    }

    @Override
    public boolean canBeUsedBy(@NotNull IVampirePlayer player) {
        return player.getActionHandler().isActionActive((ILastingAction)VampireActions.BAT.get()) || player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.SUMMON_BATS.get());
    }

    @Override
    public int getCooldown(@NotNull IVampirePlayer player) {
        return (int)((player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.SUMMON_BATS.get()) ? 0.7 : 1.0) * (double)((Integer)VampirismConfig.BALANCE.vaSummonBatsCooldown.get()).intValue() * 20.0);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaSummonBatsEnabled.get();
    }

    @Override
    public boolean showHudCooldown(Player player) {
        return true;
    }
}

