/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire.actions;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class InfectAction
extends DefaultVampireAction {
    @Override
    public int getCooldown(IVampirePlayer player) {
        return 10;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected boolean activate(@NotNull IVampirePlayer vampire, @NotNull IAction.ActivationContext context) {
        Player player = vampire.asEntity();
        Entity creature = context.targetEntity().filter(LivingEntity.class::isInstance).filter(target -> {
            if (UtilLib.canReallySee((LivingEntity)target, (LivingEntity)player, false)) {
                return false;
            }
            return this.deriveBiteableEntry((Entity)target).map(e -> e.tryInfect(vampire)).orElse(false);
        }).orElse(null);
        if (creature != null) {
            player.awardStat((ResourceLocation)ModStats.INFECTED_CREATURES.get());
            player.level().playSound(null, creature.getX(), creature.getY() + 1.5, creature.getZ(), (SoundEvent)ModSounds.VAMPIRE_BITE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BANJO.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return creature != null;
    }

    @Override
    public boolean canBeUsedBy(@NotNull IVampirePlayer player) {
        if (player.asEntity().level().getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        if (player.isRemote()) {
            Entity target = VampirismMod.proxy.getMouseOverEntity();
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                if (UtilLib.canReallySee(living, (LivingEntity)player.asEntity(), false)) {
                    return false;
                }
                return this.deriveBiteableEntry(target).map(b -> b.canBeInfected(player)).orElse(false);
            }
            return false;
        }
        return true;
    }

    @NotNull
    private Optional<? extends IBiteableEntity> deriveBiteableEntry(Entity target) {
        if (target instanceof IBiteableEntity) {
            return Optional.of((IBiteableEntity)target);
        }
        if (target instanceof PathfinderMob) {
            return ExtendedCreature.getSafe(target);
        }
        if (target instanceof Player) {
            return Optional.of(VampirePlayer.get((Player)target));
        }
        return Optional.empty();
    }
}

