/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire;

import de.teamlapen.lib.lib.storage.ISyncableSaveData;
import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BloodStats
implements IBloodStats,
ISyncableSaveData {
    private static final String NBT_KEY = "blood_stats";
    private static final Logger LOGGER = LogManager.getLogger(BloodStats.class);
    private final Player player;
    private int maxBlood = 20;
    private int bloodLevel = 20;
    private float bloodSaturationLevel = 5.0f;
    private float bloodExhaustionLevel;
    private int bloodTimer;
    private int prevBloodLevel = 20;
    private boolean changed = false;

    BloodStats(Player player) {
        this.player = player;
    }

    @Override
    public int getBloodLevel() {
        return this.bloodLevel;
    }

    void setBloodLevel(int amt) {
        this.bloodLevel = amt < 0 ? 0 : Math.min(amt, this.maxBlood);
        this.changed = true;
    }

    @Override
    public int getMaxBlood() {
        return this.maxBlood;
    }

    void setMaxBlood(int maxBlood) {
        this.maxBlood = Math.max(1, maxBlood);
        if (this.bloodLevel > maxBlood) {
            this.bloodLevel = maxBlood;
        }
        this.changed = true;
    }

    @Override
    public int getPrevBloodLevel() {
        return this.prevBloodLevel;
    }

    @Override
    public boolean needsBlood() {
        return this.bloodLevel < this.maxBlood;
    }

    public boolean onUpdate() {
        boolean regen;
        float bloodExhaustionGate;
        FoodData foodStats = this.player.getFoodData();
        foodStats.setFoodLevel(10);
        Difficulty enumDifficulty = this.player.getCommandSenderWorld().getDifficulty();
        float exhaustion = foodStats.getExhaustionLevel();
        foodStats.setExhaustion(0.0f);
        this.addExhaustion(exhaustion);
        this.prevBloodLevel = this.bloodLevel;
        float f = bloodExhaustionGate = this.player.getCommandSenderWorld().getBiome(this.player.blockPosition()).is(ModTags.Biomes.IS_VAMPIRE_BIOME) ? 6.0f : 4.0f;
        if (this.bloodExhaustionLevel > bloodExhaustionGate) {
            this.bloodExhaustionLevel -= bloodExhaustionGate;
            if (this.bloodSaturationLevel > 0.0f) {
                this.bloodSaturationLevel = Math.max(this.bloodSaturationLevel - 1.0f, 0.0f);
            } else if (enumDifficulty != Difficulty.PEACEFUL || ((Boolean)VampirismConfig.BALANCE.vpBloodUsagePeaceful.get()).booleanValue()) {
                this.bloodLevel = Math.max(this.bloodLevel - 1, 0);
            }
        }
        if ((regen = this.player.getCommandSenderWorld().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) && this.bloodSaturationLevel > 0.0f && this.player.isHurt() && this.bloodLevel >= this.maxBlood) {
            ++this.bloodTimer;
            if (this.bloodTimer >= 10) {
                float f2 = Math.min(this.bloodSaturationLevel, 6.0f);
                this.player.heal(f2 / 6.0f * this.getHealModifier());
                this.addExhaustion(f2);
                this.bloodTimer = 0;
            }
        } else if (regen && this.bloodLevel > 0 && this.player.isHurt()) {
            boolean heal;
            ++this.bloodTimer;
            boolean betterHeal = this.bloodLevel >= 18 && this.bloodTimer >= 80;
            boolean bl = heal = this.bloodTimer >= 300;
            if (betterHeal || heal) {
                this.player.heal(betterHeal ? this.getHealModifier() : 0.5f * this.getHealModifier());
                this.addExhaustion(betterHeal ? 6.0f : 3.0f);
                this.bloodTimer = 0;
            }
        } else if (this.bloodLevel <= 0) {
            ++this.bloodTimer;
            if (this.bloodTimer >= 80) {
                if (this.player.getHealth() > 10.0f || enumDifficulty == Difficulty.HARD || this.player.getHealth() > 1.0f && enumDifficulty == Difficulty.NORMAL) {
                    this.player.addEffect(new MobEffectInstance(ModEffects.NO_BLOOD, 150, 0));
                }
                this.bloodTimer = 0;
            }
        } else {
            this.bloodTimer = 0;
        }
        if (this.changed || this.prevBloodLevel != this.bloodLevel) {
            this.changed = false;
            return true;
        }
        return false;
    }

    private float getHealModifier() {
        return 1.0f + VampirePlayer.getOpt(this.player).map(s -> Float.valueOf((float)s.getLevel() / (float)s.getMaxLevel())).orElse(Float.valueOf(0.0f)).floatValue() * 0.5f;
    }

    @Override
    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        if (nbt.contains("bloodLevel")) {
            this.bloodLevel = nbt.getInt("bloodLevel");
            if (nbt.contains("bloodTimer")) {
                this.bloodTimer = nbt.getInt("bloodTimer");
                this.bloodSaturationLevel = nbt.getFloat("bloodSaturation");
                this.bloodExhaustionLevel = nbt.getFloat("bloodExhaustion");
            }
            if (nbt.contains("max_blood")) {
                this.maxBlood = nbt.getInt("max_blood");
            }
        }
    }

    int addBlood(int amount, float saturationModifier) {
        int add = Math.min(amount, this.maxBlood - this.bloodLevel);
        this.bloodLevel += add;
        this.bloodSaturationLevel = Math.min(this.bloodSaturationLevel + (float)add * saturationModifier * 2.0f, (float)this.bloodLevel);
        this.changed = true;
        return amount - add;
    }

    void addExhaustion(float amount) {
        this.addExhaustion(amount, false);
    }

    void addExhaustion(float amount, boolean ignoreModifier) {
        if (!ignoreModifier) {
            amount *= (float)this.player.getAttributeValue(ModAttributes.BLOOD_EXHAUSTION);
        }
        this.bloodExhaustionLevel = Math.min(this.bloodExhaustionLevel + amount, 40.0f);
    }

    @Override
    public void deserializeUpdateNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        if (nbt.contains("max_blood")) {
            this.setMaxBlood(nbt.getInt("max_blood"));
        }
        if (nbt.contains("bloodLevel")) {
            this.setBloodLevel(nbt.getInt("bloodLevel"));
        }
        if (nbt.contains("bloodSaturation")) {
            this.bloodSaturationLevel = nbt.getFloat("bloodSaturation");
        }
    }

    boolean removeBlood(int a, boolean allowPartial) {
        if (this.bloodLevel >= a) {
            this.bloodLevel -= a;
            this.changed = true;
            return true;
        }
        if (allowPartial) {
            this.bloodLevel = 0;
            this.changed = true;
        }
        return false;
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        this.writeNBTBlood(nbt);
        nbt.putInt("bloodTimer", this.bloodTimer);
        nbt.putFloat("bloodSaturation", this.bloodSaturationLevel);
        nbt.putFloat("bloodExhaustion", this.bloodExhaustionLevel);
        nbt.putInt("max_blood", this.maxBlood);
        return nbt;
    }

    void writeNBTBlood(@NotNull CompoundTag nbt) {
        nbt.putInt("bloodLevel", this.bloodLevel);
    }

    @Override
    @NotNull
    public CompoundTag serializeUpdateNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("bloodLevel", this.bloodLevel);
        nbt.putInt("max_blood", this.maxBlood);
        nbt.putFloat("bloodSaturation", this.bloodSaturationLevel);
        return nbt;
    }

    @Override
    public String nbtKey() {
        return NBT_KEY;
    }
}

