/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks.reward;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.core.ModTasks;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemReward
implements TaskReward {
    public static final MapCodec<ItemReward> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ItemStack.CODEC.fieldOf("item").forGetter(i -> i.reward)).apply((Applicative)inst, ItemReward::new));
    protected final ItemStack reward;

    public ItemReward(ItemStack reward) {
        this.reward = reward;
    }

    @Override
    public ITaskRewardInstance createInstance(@Nullable IFactionPlayer<?> player) {
        return new Instance(this.reward);
    }

    public List<ItemStack> getAllPossibleRewards() {
        return Collections.singletonList(this.reward);
    }

    @Override
    public MapCodec<? extends TaskReward> codec() {
        return (MapCodec)ModTasks.ITEM_REWARD.get();
    }

    @Override
    public Component description() {
        return this.reward.getItem().getDescription();
    }

    public record Instance(ItemStack reward) implements ITaskRewardInstance
    {
        public static final MapCodec<Instance> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ItemStack.CODEC.fieldOf("item").forGetter(i -> i.reward)).apply((Applicative)inst, Instance::new));

        @Override
        public void applyReward(IFactionPlayer<?> player) {
            if (!player.asEntity().addItem(this.reward.copy())) {
                player.asEntity().drop(this.reward.copy(), true);
            }
        }

        @Override
        public MapCodec<? extends ITaskRewardInstance> codec() {
            return (MapCodec)ModTasks.ITEM_REWARD_INSTANCE.get();
        }
    }
}

