/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.DefaultSkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.entity.player.vampire.skills.VampireSkills;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public abstract class VampirismSkill<T extends IFactionPlayer<T>>
extends DefaultSkill<T> {
    private final Either<ResourceKey<ISkillTree>, TagKey<ISkillTree>> skillTree;
    private Supplier<Component> description = () -> null;
    private Consumer<T> activate;
    private Consumer<T> deactivate;

    public VampirismSkill(Either<ResourceKey<ISkillTree>, TagKey<ISkillTree>> skillTree) {
        super(2);
        this.activate = player -> {};
        this.deactivate = player -> {};
        this.skillTree = skillTree;
    }

    public VampirismSkill(Either<ResourceKey<ISkillTree>, TagKey<ISkillTree>> skillTree, boolean hasDescription) {
        this(skillTree, 2, hasDescription);
    }

    public VampirismSkill(Either<ResourceKey<ISkillTree>, TagKey<ISkillTree>> skillTree, int skillPointCost, boolean hasDescription) {
        super(skillPointCost);
        this.activate = player -> {};
        this.deactivate = player -> {};
        this.skillTree = skillTree;
        if (hasDescription) {
            this.setHasDefaultDescription();
        }
    }

    @Override
    public Component getDescription() {
        return this.description.get();
    }

    @NotNull
    public VampirismSkill<T> setDescription(Supplier<Component> descriptionIn) {
        this.description = descriptionIn;
        return this;
    }

    @Override
    public Either<ResourceKey<ISkillTree>, TagKey<ISkillTree>> allowedSkillTrees() {
        return this.skillTree;
    }

    @NotNull
    public VampirismSkill<T> setHasDefaultDescription() {
        this.description = () -> Component.translatable((String)(this.getTranslationKey() + ".desc"));
        return this;
    }

    @NotNull
    public VampirismSkill<T> setToggleActions(Consumer<T> activateIn, Consumer<T> deactivateIn) {
        this.activate = activateIn;
        this.deactivate = deactivateIn;
        return this;
    }

    @Override
    protected void onDisabled(T player) {
        this.deactivate.accept(player);
        super.onDisabled(player);
    }

    @Override
    protected void onEnabled(T player) {
        this.activate.accept(player);
        super.onEnabled(player);
    }

    public static class VampireLordSkill
    extends VampirismSkill<IVampirePlayer> {
        public VampireLordSkill(int skillPointCost, boolean desc) {
            super((Either<ResourceKey<ISkillTree>, TagKey<ISkillTree>>)Either.left(VampireSkills.Trees.LORD), skillPointCost, desc);
        }

        @Override
        @NotNull
        public Optional<IPlayableFaction<?>> getFaction() {
            return Optional.of(VReference.VAMPIRE_FACTION);
        }
    }

    public static class SimpleVampireSkill
    extends VampirismSkill<IVampirePlayer> {
        public SimpleVampireSkill(int skillPointCost, boolean desc) {
            super((Either<ResourceKey<ISkillTree>, TagKey<ISkillTree>>)Either.left(VampireSkills.Trees.LEVEL), skillPointCost, desc);
        }

        @Override
        @NotNull
        public Optional<IPlayableFaction<?>> getFaction() {
            return Optional.of(VReference.VAMPIRE_FACTION);
        }
    }

    public static class HunterLordSkill
    extends VampirismSkill<IHunterPlayer> {
        public HunterLordSkill(int skillPointCost, boolean desc) {
            super((Either<ResourceKey<ISkillTree>, TagKey<ISkillTree>>)Either.left(HunterSkills.Trees.LORD), skillPointCost, desc);
        }

        @Override
        @NotNull
        public Optional<IPlayableFaction<?>> getFaction() {
            return Optional.of(VReference.HUNTER_FACTION);
        }
    }

    public static class SimpleHunterSkill
    extends VampirismSkill<IHunterPlayer> {
        public SimpleHunterSkill(int skillPointCost, boolean desc) {
            super((Either<ResourceKey<ISkillTree>, TagKey<ISkillTree>>)Either.left(HunterSkills.Trees.LEVEL), skillPointCost, desc);
        }

        @Override
        @NotNull
        public Optional<IPlayableFaction<?>> getFaction() {
            return Optional.of(VReference.HUNTER_FACTION);
        }
    }
}

