/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.hunter.skills;

import de.teamlapen.vampirism.advancements.critereon.PlayerFactionSubPredicate;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.ISkillNode;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.entity.player.lord.skills.LordSkills;
import de.teamlapen.vampirism.entity.player.skills.ActionSkill;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.entity.player.skills.SkillTree;
import de.teamlapen.vampirism.entity.player.skills.VampirismSkill;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.ApiStatus;

public class HunterSkills {
    public static final DeferredRegister<ISkill<?>> SKILLS = DeferredRegister.create(VampirismRegistries.Keys.SKILL, (String)"vampirism");
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> LEVEL_ROOT = SKILLS.register(VReference.HUNTER_FACTION.getID().getPath(), () -> new VampirismSkill.SimpleHunterSkill(0, false));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> LORD_ROOT = SKILLS.register(VReference.HUNTER_FACTION.getID().withSuffix("_lord").getPath(), () -> new VampirismSkill.SimpleHunterSkill(0, false));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> BASIC_ALCHEMY = SKILLS.register("basic_alchemy", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> DOUBLE_CROSSBOW = SKILLS.register("double_crossbow", () -> new VampirismSkill.SimpleHunterSkill(1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> ENHANCED_ARMOR = SKILLS.register("enhanced_armor", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> ENHANCED_WEAPONS = SKILLS.register("enhanced_weapons", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GARLIC_DIFFUSER = SKILLS.register("garlic_diffuser", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GARLIC_DIFFUSER_IMPROVED = SKILLS.register("garlic_diffuser_improved", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> ENHANCED_BLESSING = SKILLS.register("enhanced_blessing", () -> new VampirismSkill.SimpleHunterSkill(3, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> HUNTER_ATTACK_SPEED = SKILLS.register("hunter_attack_speed", () -> new VampirismSkill.SimpleHunterSkill(2, false).registerAttributeModifier((Holder<Attribute>)Attributes.ATTACK_SPEED, () -> (Double)VampirismConfig.BALANCE.hsSmallAttackSpeedModifier.get(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> HUNTER_ATTACK_SPEED_ADVANCED = SKILLS.register("hunter_attack_speed_advanced", () -> new VampirismSkill.SimpleHunterSkill(2, true).registerAttributeModifier((Holder<Attribute>)Attributes.ATTACK_SPEED, () -> (Double)VampirismConfig.BALANCE.hsMajorAttackSpeedModifier.get(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> HUNTER_ATTACK_DAMAGE = SKILLS.register("hunter_attack_damage", () -> new VampirismSkill.SimpleHunterSkill(2, false).registerAttributeModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, () -> (Double)VampirismConfig.BALANCE.hsSmallAttackDamageModifier.get(), AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> HUNTER_AWARENESS = SKILLS.register("hunter_awareness", () -> new ActionSkill(HunterActions.AWARENESS_HUNTER, Trees.LEVEL, 2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> HUNTER_DISGUISE = SKILLS.register("hunter_disguise", () -> new ActionSkill(HunterActions.DISGUISE_HUNTER, Trees.LEVEL, 1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> PURIFIED_GARLIC = SKILLS.register("purified_garlic", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> STAKE1 = SKILLS.register("stake1", () -> new VampirismSkill.SimpleHunterSkill(2, false).setDescription(() -> {
        MutableComponent desc = Component.translatable((String)"skill.vampirism.stake1.desc", (Object[])new Object[]{(int)((Double)VampirismConfig.BALANCE.hsInstantKill1MaxHealth.get() * 100.0)});
        if (((Boolean)VampirismConfig.BALANCE.hsInstantKill1FromBehind.get()).booleanValue()) {
            desc.append((Component)Component.literal((String)" "));
            desc.append((Component)Component.translatable((String)"text.vampirism.from_behind"));
        }
        return desc;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> STAKE2 = SKILLS.register("stake2", () -> new VampirismSkill.SimpleHunterSkill(2, false).setDescription(() -> {
        MutableComponent desc = (Boolean)VampirismConfig.BALANCE.hsInstantKill2OnlyNPC.get() != false ? Component.translatable((String)"skill.vampirism.stake2.desc_npc", (Object[])new Object[]{VampirismConfig.BALANCE.hsInstantKill2MaxHealth.get()}) : Component.translatable((String)"skill.vampirism.stake2.desc_all", (Object[])new Object[]{VampirismConfig.BALANCE.hsInstantKill2MaxHealth.get()});
        return desc;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> TECH_WEAPONS = SKILLS.register("tech_weapons", () -> new VampirismSkill.SimpleHunterSkill(3, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> WEAPON_TABLE = SKILLS.register("weapon_table", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> DURABLE_BREWING = SKILLS.register("durable_brewing", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> CONCENTRATED_BREWING = SKILLS.register("concentrated_brewing", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> MULTITASK_BREWING = SKILLS.register("multitask_brewing", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> EFFICIENT_BREWING = SKILLS.register("efficient_brewing", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> MASTER_BREWER = SKILLS.register("master_brewer", () -> new VampirismSkill.SimpleHunterSkill(3, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> SWIFT_BREWING = SKILLS.register("swift_brewing", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> CONCENTRATED_DURABLE_BREWING = SKILLS.register("concentrated_durable_brewing", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> POTION_RESISTANCE = SKILLS.register("potion_resistance", () -> new ActionSkill(HunterActions.POTION_RESISTANCE_HUNTER, Trees.LEVEL, 2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> CRUCIFIX_WIELDER = SKILLS.register("crucifix_wielder", () -> new VampirismSkill.SimpleHunterSkill(1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> ULTIMATE_CRUCIFIX = SKILLS.register("ultimate_crucifix", () -> new VampirismSkill.SimpleHunterSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> MINION_COLLECT = SKILLS.register("hunter_minion_collect", () -> new VampirismSkill.HunterLordSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> MINION_STATS_INCREASE = SKILLS.register("hunter_minion_stats_increase", () -> new VampirismSkill.HunterLordSkill(3, true).setToggleActions(hunter -> hunter.updateMinionAttributes(true), hunter -> hunter.updateMinionAttributes(false)));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> MINION_TECH_CROSSBOWS = SKILLS.register("minion_tech_crossbows", () -> new VampirismSkill.HunterLordSkill(1, true));

    @ApiStatus.Internal
    public static void register(IEventBus bus) {
        SKILLS.register(bus);
    }

    public static class Trees {
        public static final ResourceKey<ISkillTree> LEVEL = Trees.tree("level");
        public static final ResourceKey<ISkillTree> LORD = Trees.tree("lord");

        private static ResourceKey<ISkillTree> tree(String path) {
            return ResourceKey.create(VampirismRegistries.Keys.SKILL_TREE, (ResourceLocation)VResourceLocation.mod("hunter/" + path));
        }

        public static void createSkillTrees(BootstrapContext<ISkillTree> context) {
            HolderGetter lookup = context.lookup(VampirismRegistries.Keys.SKILL_NODE);
            context.register(LEVEL, (Object)new SkillTree(VReference.HUNTER_FACTION, EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)PlayerFactionSubPredicate.faction(VReference.HUNTER_FACTION)).build(), new ItemStack((ItemLike)ModItems.VAMPIRE_BOOK.get()), (Component)Component.translatable((String)"text.vampirism.skills.level")));
            context.register(LORD, (Object)new SkillTree(VReference.HUNTER_FACTION, EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)PlayerFactionSubPredicate.lord(VReference.HUNTER_FACTION)).build(), new ItemStack((ItemLike)ModItems.HUNTER_MINION_EQUIPMENT.get()), (Component)Component.translatable((String)"text.vampirism.skills.lord")));
        }
    }

    public static class Nodes {
        public static final ResourceKey<ISkillNode> LEVEL_ROOT = Nodes.node("level_root");
        public static final ResourceKey<ISkillNode> SKILL2 = Nodes.node("skill2");
        public static final ResourceKey<ISkillNode> SKILL3 = Nodes.node("skill3");
        public static final ResourceKey<ISkillNode> SKILL4 = Nodes.node("skill4");
        public static final ResourceKey<ISkillNode> ALCHEMY1 = Nodes.node("alchemy1");
        public static final ResourceKey<ISkillNode> ALCHEMY2 = Nodes.node("alchemy2");
        public static final ResourceKey<ISkillNode> ALCHEMY3 = Nodes.node("alchemy3");
        public static final ResourceKey<ISkillNode> ALCHEMY4 = Nodes.node("alchemy4");
        public static final ResourceKey<ISkillNode> ALCHEMY5 = Nodes.node("alchemy5");
        public static final ResourceKey<ISkillNode> ALCHEMY6 = Nodes.node("alchemy6");
        public static final ResourceKey<ISkillNode> POTION1 = Nodes.node("potion1");
        public static final ResourceKey<ISkillNode> POTION2 = Nodes.node("potion2");
        public static final ResourceKey<ISkillNode> POTION3 = Nodes.node("potion3");
        public static final ResourceKey<ISkillNode> POTION4 = Nodes.node("potion4");
        public static final ResourceKey<ISkillNode> POTION5 = Nodes.node("potion5");
        public static final ResourceKey<ISkillNode> POTION6 = Nodes.node("potion6");
        public static final ResourceKey<ISkillNode> WEAPON1 = Nodes.node("weapon1");
        public static final ResourceKey<ISkillNode> WEAPON2 = Nodes.node("weapon2");
        public static final ResourceKey<ISkillNode> WEAPON3 = Nodes.node("weapon3");
        public static final ResourceKey<ISkillNode> WEAPON4 = Nodes.node("weapon4");
        public static final ResourceKey<ISkillNode> WEAPON5 = Nodes.node("weapon5");
        public static final ResourceKey<ISkillNode> WEAPON6 = Nodes.node("weapon6");
        public static final ResourceKey<ISkillNode> LORD_ROOT = Nodes.node("lord_root");
        public static final ResourceKey<ISkillNode> LORD_2 = Nodes.node("lord_2");
        public static final ResourceKey<ISkillNode> LORD_3 = Nodes.node("lord_3");
        public static final ResourceKey<ISkillNode> LORD_4 = Nodes.node("lord_4");
        public static final ResourceKey<ISkillNode> LORD_5 = Nodes.node("lord_5");
        public static final ResourceKey<ISkillNode> LORD_6 = Nodes.node("lord_6");

        private static ResourceKey<ISkillNode> node(String path) {
            return ResourceKey.create(VampirismRegistries.Keys.SKILL_NODE, (ResourceLocation)VResourceLocation.mod("hunter/" + path));
        }

        public static void createSkillNodes(BootstrapContext<ISkillNode> context) {
            context.register(LEVEL_ROOT, (Object)new SkillNode(new Holder[]{LEVEL_ROOT}));
            context.register(SKILL2, (Object)new SkillNode(new Holder[]{STAKE1}));
            context.register(SKILL3, (Object)new SkillNode(new Holder[]{WEAPON_TABLE}));
            context.register(SKILL4, (Object)new SkillNode(new Holder[]{HUNTER_DISGUISE}));
            context.register(ALCHEMY1, (Object)new SkillNode(new Holder[]{BASIC_ALCHEMY}));
            context.register(ALCHEMY2, (Object)new SkillNode(new Holder[]{GARLIC_DIFFUSER}));
            context.register(ALCHEMY3, (Object)new SkillNode(new Holder[]{CRUCIFIX_WIELDER}));
            context.register(ALCHEMY4, (Object)new SkillNode(new Holder[]{PURIFIED_GARLIC, ENHANCED_BLESSING}));
            context.register(ALCHEMY5, (Object)new SkillNode(new Holder[]{GARLIC_DIFFUSER_IMPROVED, ULTIMATE_CRUCIFIX}));
            context.register(ALCHEMY6, (Object)new SkillNode(new Holder[]{HUNTER_AWARENESS}));
            context.register(POTION1, (Object)new SkillNode(new Holder[]{MULTITASK_BREWING}));
            context.register(POTION2, (Object)new SkillNode(new Holder[]{DURABLE_BREWING, CONCENTRATED_BREWING}));
            context.register(POTION3, (Object)new SkillNode(new Holder[]{SWIFT_BREWING, EFFICIENT_BREWING}));
            context.register(POTION4, (Object)new SkillNode(new Holder[]{MASTER_BREWER}));
            context.register(POTION5, (Object)new SkillNode(new Holder[]{POTION_RESISTANCE}));
            context.register(POTION6, (Object)new SkillNode(new Holder[]{CONCENTRATED_DURABLE_BREWING}));
            context.register(WEAPON1, (Object)new SkillNode(new Holder[]{HUNTER_ATTACK_SPEED, HUNTER_ATTACK_DAMAGE}));
            context.register(WEAPON2, (Object)new SkillNode(new Holder[]{DOUBLE_CROSSBOW}));
            context.register(WEAPON3, (Object)new SkillNode(new Holder[]{HUNTER_ATTACK_SPEED_ADVANCED, ENHANCED_WEAPONS}));
            context.register(WEAPON4, (Object)new SkillNode(new Holder[]{ENHANCED_ARMOR}));
            context.register(WEAPON5, (Object)new SkillNode(new Holder[]{TECH_WEAPONS}));
            context.register(WEAPON6, (Object)new SkillNode(new Holder[]{STAKE2}));
            context.register(LORD_ROOT, (Object)new SkillNode(new Holder[]{LORD_ROOT}));
            context.register(LORD_2, (Object)new SkillNode(new Holder[]{MINION_STATS_INCREASE}));
            context.register(LORD_3, (Object)new SkillNode(new Holder[]{LordSkills.LORD_SPEED, LordSkills.LORD_ATTACK_SPEED}));
            context.register(LORD_4, (Object)new SkillNode(new Holder[]{MINION_COLLECT}));
            context.register(LORD_5, (Object)new SkillNode(new Holder[]{LordSkills.MINION_RECOVERY}));
            context.register(LORD_6, (Object)new SkillNode(new Holder[]{MINION_TECH_CROSSBOWS}));
        }
    }
}

