/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.storage.IAttachment;
import de.teamlapen.lib.lib.storage.ISyncable;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.entity.player.TaskManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FactionBasePlayer<T extends IFactionPlayer<T>>
implements IFactionPlayer<T>,
IAttachment,
IPlayerEventListener {
    private static final Logger LOGGER = LogManager.getLogger(FactionBasePlayer.class);
    protected final Player player;
    @Nullable
    private final TaskManager taskManager;

    public FactionBasePlayer(Player player) {
        this.player = player;
        this.taskManager = player instanceof ServerPlayer ? new TaskManager((ServerPlayer)player, this, (IPlayableFaction<?>)this.getFaction()) : null;
    }

    @Override
    @NotNull
    public Player asEntity() {
        return this.player;
    }

    @Override
    public int getLevel() {
        return VampirismAPI.factionPlayerHandler(this.player).getCurrentLevel((IPlayableFaction<?>)this.getFaction());
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this.player;
    }

    @Override
    public Player getRepresentingPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    @Override
    public boolean isRemote() {
        if (this.player.level() == null) {
            LOGGER.error("Trying to check if remote, but world is not set yet", new Throwable("World not loaded").fillInStackTrace());
            return false;
        }
        return this.player.level().isClientSide;
    }

    @Override
    @MustBeInvokedByOverriders
    public void onDeath(DamageSource src) {
        this.getSkillHandler().damageRefinements();
    }

    @Override
    @MustBeInvokedByOverriders
    public void onUpdate() {
        if (!this.isRemote()) {
            this.taskManager.tick();
        }
    }

    public void sync(boolean all) {
        HelperLib.sync(this, (Entity)this.player, all);
    }

    protected void sync(@NotNull CompoundTag data, boolean all) {
        HelperLib.sync(this, data, (Entity)this.player, all);
    }

    protected void syncProperty(@NotNull ISyncable object, boolean all) {
        CompoundTag tag = new CompoundTag();
        tag.put(object.nbtKey(), (Tag)object.serializeUpdateNBT((HolderLookup.Provider)this.asEntity().registryAccess()));
        HelperLib.sync(this, tag, (Entity)this.player, all);
    }

    @Override
    @MustBeInvokedByOverriders
    public void onLevelChanged(int newLevel, int oldLevel) {
        if (!this.isRemote()) {
            if (newLevel <= 0) {
                this.getSkillHandler().reset();
                this.getActionHandler().resetTimers();
                this.sync(true);
            }
        } else if (newLevel == 0) {
            this.getActionHandler().resetTimers();
            this.getSkillHandler().resetRefinements();
        }
    }

    @Override
    @MustBeInvokedByOverriders
    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.taskManager != null) {
            tag.put(this.taskManager.nbtKey(), (Tag)this.taskManager.serializeNBT(provider));
        }
        return tag;
    }

    @Override
    @MustBeInvokedByOverriders
    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        if (this.taskManager != null) {
            this.taskManager.deserializeNBT(provider, nbt.getCompound(this.taskManager.nbtKey()));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void deserializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
    }

    @Override
    @MustBeInvokedByOverriders
    @NotNull
    public CompoundTag serializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return new CompoundTag();
    }
}

