/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.vampirism.api.entity.minion.IMinionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.entity.minion.management.DefaultMinionTask;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefendAreaTask
extends DefaultMinionTask<Desc, MinionData> {
    @Override
    public Desc activateTask(@Nullable Player lord, @Nullable IMinionEntity minion, MinionData inventory) {
        this.triggerAdvancements(lord);
        BlockPos pos = minion != null ? minion.asEntity().blockPosition() : (lord != null ? lord.blockPosition() : null);
        return pos == null ? null : new Desc(pos, 10);
    }

    @Override
    public void deactivateTask(Desc desc) {
    }

    @Override
    @NotNull
    public Desc readFromNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        BlockPos pos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)nbt, (String)"center").orElseThrow();
        int dist = nbt.getInt("radius");
        return new Desc(pos, dist);
    }

    public static class Desc
    implements IMinionTask.IMinionTaskDesc<MinionData> {
        public final BlockPos center;
        public final int distance;

        public Desc(BlockPos center, int distance) {
            this.center = center;
            this.distance = distance;
        }

        @Override
        @NotNull
        public IMinionTask<?, MinionData> getTask() {
            return (IMinionTask)MinionTasks.DEFEND_AREA.get();
        }

        @Override
        public void writeToNBT(@NotNull CompoundTag nbt) {
            nbt.put("center", NbtUtils.writeBlockPos((BlockPos)this.center));
            nbt.putInt("radius", this.distance);
        }
    }
}

