/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.goals;

import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.entity.ai.goals.MoveToPositionGoal;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FollowLordGoal
extends MoveToPositionGoal<MinionEntity<?>> {
    @Nullable
    private ILordPlayer lord;

    public FollowLordGoal(@NotNull MinionEntity<?> entity, double followSpeedIn) {
        super(entity, followSpeedIn, 5.0f, 15.0f, true, true);
    }

    @Override
    public boolean canContinueToUse() {
        return super.canContinueToUse() && ((MinionEntity)this.entity).getCurrentTask().filter(task -> task.getTask() == MinionTasks.FOLLOW_LORD.get() || task.getTask() == MinionTasks.PROTECT_LORD.get()).isPresent();
    }

    @Override
    public boolean canUse() {
        if (((MinionEntity)this.entity).getCurrentTask().filter(task -> task.getTask() == MinionTasks.FOLLOW_LORD.get() || task.getTask() == MinionTasks.PROTECT_LORD.get()).isEmpty()) {
            return false;
        }
        Optional<ILordPlayer> lord = ((MinionEntity)this.entity).getLordOpt();
        if (lord.isEmpty()) {
            return false;
        }
        this.lord = lord.get();
        if (!super.canUse()) {
            this.lord = null;
            return false;
        }
        return true;
    }

    @Override
    public void stop() {
        super.stop();
        this.lord = null;
    }

    @Override
    @NotNull
    protected Vec3 getLookPosition() {
        return this.lord.getPlayer().getEyePosition(1.0f);
    }

    @Override
    @NotNull
    protected Vec3i getTargetPosition() {
        return this.lord.getPlayer().blockPosition();
    }
}

