/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.ICaptureIgnore;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.ai.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.inventory.HunterTrainerMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterTrainerEntity
extends HunterBaseEntity
implements ForceLookEntityGoal.TaskOwner,
ICaptureIgnore {
    private static final Component name = Component.translatable((String)"container.huntertrainer");
    private static final int MOVE_TO_RESTRICT_PRIO = 3;
    @Nullable
    private Player trainee;
    private boolean shouldCreateHome;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        return VampirismEntity.getAttributeBuilder().add(Attributes.MAX_HEALTH, 300.0).add(Attributes.ATTACK_DAMAGE, 19.0).add(Attributes.MOVEMENT_SPEED, 0.17).add(Attributes.FOLLOW_RANGE, 5.0);
    }

    public HunterTrainerEntity(EntityType<? extends HunterTrainerEntity> type, Level world) {
        super(type, world, false);
        this.saveHome = true;
        this.hasArms = true;
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.peaceful = true;
        this.setDontDropEquipment();
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("createHome", this.shouldCreateHome);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.trainee != null && !(this.trainee.containerMenu instanceof HunterTrainerMenu)) {
            this.trainee = null;
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        return super.hurt(source, amount);
    }

    @Override
    @NotNull
    public Optional<Player> getForceLookTarget() {
        return Optional.ofNullable(this.trainee);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("createHome") && (this.shouldCreateHome = nbt.getBoolean("createHome")) && this.getRestrictCenter().equals((Object)BlockPos.ZERO)) {
            this.restrictTo(this.blockPosition(), 5);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setItemSlot(EquipmentSlot.HEAD, HunterBaseEntity.HatType.HAT_0.getHeadItem());
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return super.removeWhenFarAway(distanceToClosestPlayer) && this.getHome() == null;
    }

    @Override
    public void setHome(AABB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    public boolean shouldShowName() {
        return true;
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        boolean flag;
        if (this.tryCureSanguinare(player)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        boolean bl = flag = !stack.isEmpty() && stack.getItem() instanceof SpawnEggItem;
        if (!flag && this.isAlive() && !player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            int lvl = VampirismPlayerAttributes.get((Player)player).hunterLevel;
            if (!this.level().isClientSide && lvl > 0) {
                if (HunterLeveling.getTrainerRequirement(lvl + 1).isPresent()) {
                    if (this.trainee == null) {
                        player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new HunterTrainerMenu(id, playerInventory, this), name));
                        this.trainee = player;
                        this.getNavigation().stop();
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.i_am_busy_right_now"));
                    }
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.hunter_trainer.trainer_level_wrong"));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, new ForceLookEntityGoal<HunterTrainerEntity>(this));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 13.0f));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, VampireBaseEntity.class, 17.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
    }
}

