/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.hunter.IBasicHunter;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.hunter.IVampirismCrossbowUser;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.ai.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.ai.goals.RangedHunterCrossbowAttackGoal;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.inventory.HunterBasicMenu;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import de.teamlapen.vampirism.util.HunterVillage;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.CommonHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicHunterEntity
extends HunterBaseEntity
implements IBasicHunter,
ForceLookEntityGoal.TaskOwner,
IVampirismCrossbowUser,
IEntityActionUser {
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.defineId(BasicHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> WATCHED_ID = SynchedEntityData.defineId(BasicHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(BasicHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.defineId(BasicHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component name = Component.translatable((String)"container.hunter");
    private final int MAX_LEVEL = 3;
    @NotNull
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    @NotNull
    private final EntityActionTier entitytier;
    @Nullable
    private Player trainee;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private boolean attack;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampirismEntity.getAttributeBuilder().add(Attributes.MAX_HEALTH, (double)BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder.add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, BalanceMobProps.mobProps.VAMPIRE_HUNTER_SPEED);
    }

    public BasicHunterEntity(EntityType<? extends BasicHunterEntity> type, Level world) {
        super(type, world, true);
        this.saveHome = true;
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.setDontDropEquipment();
        this.entitytier = EntityActionTier.Medium;
        this.entityclass = EntityClassType.getRandomClass(this.getRandom());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<BasicHunterEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("level", this.getEntityLevel());
        nbt.putBoolean("crossbow", this.isHoldingCrossbow());
        nbt.putBoolean("attack", this.attack);
        nbt.putInt("type", this.getEntityTextureType());
        nbt.putInt("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
    }

    @Override
    public void attackVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = true;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.trainee != null && !(this.trainee.containerMenu instanceof HunterBasicMenu)) {
            this.trainee = null;
        }
        if (!this.level().isClientSide) {
            LivingEntity target = this.getTarget();
            int id = target == null ? 0 : target.getId();
            this.updateWatchedId(id);
            if (this.tickCount % 512 == 0 && this.getRandom().nextInt(500) == 0) {
                BlockPos randomDestination = new BlockPos(this.getRandom().nextInt(30000) - 15000, 100, this.getRandom().nextInt(30000) - 15000);
                randomDestination = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomDestination);
                this.setHomeArea(randomDestination, 10);
            }
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    public void convertToMinion(@NotNull Player lord) {
        FactionPlayerHandler fph = FactionPlayerHandler.get(lord);
        if (fph.getMaxMinions() > 0) {
            MinionWorldData.getData(lord.level()).map(w -> w.getOrCreateController(fph)).ifPresent(controller -> {
                if (controller.hasFreeMinionSlot()) {
                    if (fph.getCurrentFaction() == this.getFaction()) {
                        boolean hasIncreasedStats = fph.getCurrentFactionPlayer().map(s -> s.getSkillHandler().isSkillEnabled((ISkill)HunterSkills.MINION_STATS_INCREASE.get())).orElse(false);
                        HunterMinionEntity.HunterMinionData data = new HunterMinionEntity.HunterMinionData("Minion", this.getEntityTextureType(), this.getEntityTextureType() % 4, false, hasIncreasedStats);
                        data.updateEntityCaps(this.serializeAttachments((HolderLookup.Provider)lord.registryAccess()));
                        int id = controller.createNewMinionSlot(data, (EntityType)ModEntities.HUNTER_MINION.get());
                        if (id < 0) {
                            LOGGER.error("Failed to get minion slot");
                            return;
                        }
                        HunterMinionEntity minion = (HunterMinionEntity)((EntityType)ModEntities.HUNTER_MINION.get()).create(this.level());
                        minion.claimMinionSlot(id, (PlayerMinionController)controller);
                        minion.copyPosition((Entity)this);
                        minion.markAsConverted();
                        controller.activateTask(0, (IMinionTask)MinionTasks.STAY.get());
                        UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)minion);
                    } else {
                        LOGGER.warn("Wrong faction for minion");
                    }
                } else {
                    LOGGER.warn("No free slot");
                }
            });
        } else {
            LOGGER.error("Can't have minions");
        }
    }

    @Override
    public void defendVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = false;
    }

    @Override
    public ActionHandlerEntity<?> getActionHandler() {
        return this.entityActionHandler;
    }

    @Override
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public void die(@NotNull DamageSource cause) {
        if (this.villageAttributes == null) {
            BadOmenEffect.handlePotentialBannerKill(cause.getEntity(), this);
        }
        super.die(cause);
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    @NotNull
    public Optional<Player> getForceLookTarget() {
        return Optional.ofNullable(this.trainee);
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        boolean flag = super.doHurtTarget(entity);
        if (flag && this.getMainHandItem().isEmpty()) {
            this.swing(InteractionHand.MAIN_HAND);
        }
        return flag;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (reason != MobSpawnType.SPAWN_EGG && reason != MobSpawnType.BUCKET && reason != MobSpawnType.CONVERSION && reason != MobSpawnType.COMMAND && this.getRandom().nextInt(50) == 0) {
            this.setItemSlot(EquipmentSlot.HEAD, HunterVillage.createBanner((HolderLookup.Provider)worldIn.registryAccess()));
        }
        this.getEntityData().set(TYPE, (Object)this.getRandom().nextInt(126));
        this.randomEquipments();
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void randomEquipments() {
        HunterBaseEntity.HatType[] hatTypes = HunterBaseEntity.HatType.values();
        HunterBaseEntity.HatType hat = hatTypes[this.getRandom().nextInt(hatTypes.length)];
        this.setItemSlot(EquipmentSlot.HEAD, hat.getHeadItem());
        HunterBaseEntity.EquipmentType equipment = switch (this.random.nextInt(4)) {
            case 1 -> HunterBaseEntity.EquipmentType.STAKE;
            case 2 -> HunterBaseEntity.EquipmentType.AXE;
            case 3 -> HunterBaseEntity.EquipmentType.CROSSBOW;
            default -> HunterBaseEntity.EquipmentType.NONE;
        };
        this.setItemSlot(EquipmentSlot.MAINHAND, equipment.getMainHand());
        this.setItemSlot(EquipmentSlot.OFFHAND, equipment.getOffHand());
        this.setDontDropEquipment();
    }

    @Override
    public int getMaxEntityLevel() {
        return 3;
    }

    @Override
    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public int getEntityTextureType() {
        return Math.max(0, (Integer)this.getEntityData().get(TYPE));
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public boolean isLookingForHome() {
        return this.getHome() == null;
    }

    @Override
    public int getEntityLevel() {
        return (Integer)this.getEntityData().get(LEVEL);
    }

    @Override
    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.getEntityData().set(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 3) {
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1000000, 1, false, false));
            }
        }
    }

    @Override
    public void makeNormalHunter() {
        super.setHome(null);
        this.disableMoveTowardsRestriction();
    }

    @Override
    public void makeVillageHunter(AABB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tagCompund) {
        super.readAdditionalSaveData(tagCompund);
        if (tagCompund.contains("level")) {
            this.setEntityLevel(tagCompund.getInt("level"));
        }
        if (tagCompund.contains("crossbow") && tagCompund.getBoolean("crossbow")) {
            this.setLeftHanded(true);
            this.setItemSlot(EquipmentSlot.MAINHAND, ModItems.BASIC_CROSSBOW.toStack());
        } else {
            this.setLeftHanded(false);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        if (tagCompund.contains("attack")) {
            this.attack = tagCompund.getBoolean("attack");
        }
        if (tagCompund.contains("type")) {
            int t = tagCompund.getInt("type");
            this.getEntityData().set(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
    }

    @Override
    public void stopVillageAttackDefense() {
        this.setCustomName(null);
        this.villageAttributes = null;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return super.removeWhenFarAway(distanceToClosestPlayer) && this.getHome() != null;
    }

    @Override
    public int suggestEntityLevel(@NotNull Difficulty d) {
        return switch (this.random.nextInt(6)) {
            case 0 -> (int)((float)d.minPercLevel() / 100.0f * 3.0f);
            case 1 -> (int)((float)d.avgPercLevel() / 100.0f * 3.0f);
            case 2 -> (int)((float)d.maxPercLevel() / 100.0f * 3.0f);
            default -> this.random.nextInt(4);
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LEVEL, (Object)-1);
        builder.define(WATCHED_ID, (Object)0);
        builder.define(TYPE, (Object)-1);
        builder.define(IS_CHARGING_CROSSBOW, (Object)false);
    }

    protected int getBaseExperienceReward() {
        this.xpReward = 6 + this.getEntityLevel();
        return super.getBaseExperienceReward();
    }

    @Override
    @NotNull
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? (EntityType)ModEntities.HUNTER_IMOB.get() : (EntityType)ModEntities.HUNTER.get();
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.tryCureSanguinare(player)) {
            return InteractionResult.SUCCESS;
        }
        int hunterLevel = VampirismPlayerAttributes.get((Player)player).hunterLevel;
        if (this.isAlive() && !player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND && !this.level().isClientSide) {
            if (HunterLeveling.getBasicHunterRequirement(hunterLevel + 1).isPresent()) {
                if (this.trainee == null) {
                    player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new HunterBasicMenu(id, playerInventory, this), name));
                    this.trainee = player;
                    this.getNavigation().stop();
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.i_am_busy_right_now"));
                }
                return InteractionResult.SUCCESS;
            }
            if (hunterLevel > 0) {
                FactionPlayerHandler fph = FactionPlayerHandler.get(player);
                if (fph.getMaxMinions() > 0) {
                    ItemStack heldItem = player.getItemInHand(hand);
                    if (this.getEntityLevel() > 0) {
                        if (heldItem.getItem() == ModItems.HUNTER_MINION_EQUIPMENT.get()) {
                            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.basic_hunter.minion.unavailable"), true);
                        }
                    } else {
                        boolean freeSlot = MinionWorldData.getData(player.level()).map(data -> data.getOrCreateController(fph)).map(PlayerMinionController::hasFreeMinionSlot).orElse(false);
                        player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.basic_hunter.minion.available"), false);
                        if (heldItem.getItem() == ModItems.HUNTER_MINION_EQUIPMENT.get()) {
                            if (!freeSlot) {
                                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.basic_hunter.minion.no_free_slot"), false);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.basic_hunter.minion.start_serving"), false);
                                this.convertToMinion(player);
                                if (!player.getAbilities().instabuild) {
                                    heldItem.shrink(1);
                                }
                            }
                        } else if (freeSlot) {
                            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.basic_hunter.minion.require_equipment", (Object[])new Object[]{Component.translatable((String)((Item)ModItems.HUNTER_MINION_EQUIPMENT.get()).getDescriptionId())}), false);
                        }
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.basic_hunter.cannot_train_you_any_further"), false);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    public void setChargingCrossbow(boolean p_213671_1_) {
        this.getEntityData().set(IS_CHARGING_CROSSBOW, (Object)p_213671_1_);
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public void performRangedAttack(@NotNull LivingEntity p_82196_1_, float p_82196_2_) {
        this.performCrossbowAttack((LivingEntity)this, 1.6f);
    }

    @Override
    public boolean isHoldingCrossbow() {
        return this.isHolding(stack -> stack.getItem() instanceof IVampirismCrossbow);
    }

    @Override
    public boolean isChargingCrossbow() {
        return (Boolean)this.getEntityData().get(IS_CHARGING_CROSSBOW);
    }

    @Nonnull
    public ItemStack getProjectile(ItemStack stack) {
        if (stack.getItem() instanceof IVampirismCrossbow) {
            return CommonHooks.getProjectile((LivingEntity)this, (ItemStack)stack, (ItemStack)((CrossbowArrowItem)ModItems.CROSSBOW_ARROW_NORMAL.get()).getDefaultInstance());
        }
        return super.getProjectile(stack);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(3, new ForceLookEntityGoal<BasicHunterEntity>(this));
        this.goalSelector.addGoal(3, new RangedHunterCrossbowAttackGoal<BasicHunterEntity>(this, 0.6, 60.0f));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, (double)0.7f, false, 300, () -> false));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7, 50));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 13.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, VampireBaseEntity.class, 17.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{IHunterMob.class}));
        this.targetSelector.addGoal(2, new AttackVillageGoal<BasicHunterEntity>(this));
        this.targetSelector.addGoal(2, new DefendVillageGoal<BasicHunterEntity>(this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal<PathfinderMob>(this, (Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)){

            protected double getFollowDistance() {
                return super.getFollowDistance() / 2.0;
            }
        });
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true, true));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, PatrollingMonster.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, (TagKey<Structure>)StructureTags.VILLAGE)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getEntityLevel(), 0);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION + BalanceMobProps.mobProps.VAMPIRE_HUNTER_MAX_HEALTH_PL * (double)l);
        AttributeInstance attributeInstance = this.getAttribute(Attributes.ATTACK_DAMAGE);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.setBaseValue(3.0 + BalanceMobProps.mobProps.VAMPIRE_HUNTER_ATTACK_DAMAGE_PL * (double)l);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(BalanceMobProps.mobProps.VAMPIRE_HUNTER_SPEED);
    }

    private int getWatchedId() {
        return (Integer)this.getEntityData().get(WATCHED_ID);
    }

    private void updateWatchedId(int id) {
        this.getEntityData().set(WATCHED_ID, (Object)id);
    }

    public static class IMob
    extends BasicHunterEntity
    implements Enemy {
        public IMob(EntityType<? extends BasicHunterEntity> type, Level world) {
            super(type, world);
        }
    }
}

