/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.api.VampirismDataMaps;
import de.teamlapen.vampirism.api.datamaps.IConverterEntry;
import de.teamlapen.vampirism.api.datamaps.IEntityBlood;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.core.ModDataMaps;
import de.teamlapen.vampirism.datamaps.ConverterEntry;
import de.teamlapen.vampirism.entity.converted.BiteableEntryManager;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampirismEntityRegistry
implements IVampirismEntityRegistry {
    @NotNull
    public final BiteableEntryManager biteableEntryManager = new BiteableEntryManager();

    @Override
    @Nullable
    public IConvertedCreature<?> convert(@NotNull PathfinderMob entity) {
        Holder.Reference holder = entity.getType().builtInRegistryHolder();
        return Optional.ofNullable((IEntityBlood)holder.getData(VampirismDataMaps.ENTITY_BLOOD.get())).filter(s -> s.blood() > 0).map(arg_0 -> VampirismEntityRegistry.lambda$convert$1((Holder)holder, arg_0)).map(s -> s.converter().createHandler(s.overlay().orElse(null))).map(s -> s.createFrom(entity)).orElse(null);
    }

    @Override
    @NotNull
    public Map<EntityType<?>, ResourceLocation> getConvertibleOverlay() {
        DefaultedRegistry registry = BuiltInRegistries.ENTITY_TYPE;
        return Map.ofEntries((Map.Entry[])registry.getDataMap(ModDataMaps.ENTITY_CONVERTER_MAP).entrySet().stream().flatMap(s -> ((IConverterEntry)s.getValue()).overlay().flatMap(l -> Optional.ofNullable((EntityType)registry.get((ResourceKey)s.getKey())).map(p -> Map.entry(p, l))).stream()).toArray(Map.Entry[]::new));
    }

    @Override
    @Nullable
    public ResourceLocation getConvertibleOverlay(@NotNull String originalEntity) {
        return BuiltInRegistries.ENTITY_TYPE.getHolder(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)originalEntity))).map(s -> (IConverterEntry)s.getData(VampirismDataMaps.ENTITY_CONVERTER.get())).flatMap(IConverterEntry::overlay).orElse(null);
    }

    @Override
    @Nullable
    public IEntityBlood getEntry(@NotNull PathfinderMob creature) {
        return this.biteableEntryManager.get(creature);
    }

    @Override
    @Nullable
    public IConverterEntry getConverterEntry(@NotNull PathfinderMob creature) {
        return (IConverterEntry)creature.getType().builtInRegistryHolder().getData(ModDataMaps.ENTITY_CONVERTER_MAP);
    }

    @Override
    @NotNull
    public IEntityBlood getOrCreateEntry(PathfinderMob creature) {
        return this.biteableEntryManager.getOrCalculate(creature);
    }

    private static /* synthetic */ IConverterEntry lambda$convert$1(Holder holder, IEntityBlood a) {
        return (IConverterEntry)holder.getData(VampirismDataMaps.ENTITY_CONVERTER.get());
    }

    public record DefaultHelper(ConverterEntry.ConvertingAttributeModifier attributes) implements IConvertingHandler.IDefaultHelper
    {
        @Override
        public Map<Holder<Attribute>, Pair<FloatProvider, Double>> getAttributeModifier() {
            return this.attributes.attributeModifier();
        }
    }
}

